"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const apigateway = require("@aws-cdk/aws-apigateway");
const lambda = require("@aws-cdk/aws-lambda");
const path = require("path");
var BREF_LAYER_VERSION;
(function (BREF_LAYER_VERSION) {
    BREF_LAYER_VERSION["PHP_74_FPM"] = "arn:aws:lambda:ap-northeast-1:209497400698:layer:php-74-fpm:10";
})(BREF_LAYER_VERSION || (BREF_LAYER_VERSION = {}));
class ServerlessApi extends cdk.Construct {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const vendorLayer = new lambda.LayerVersion(this, 'vendorLayer', {
            code: lambda.Code.fromAsset(path.join(__dirname, '../composer')),
        });
        this.handler = (_a = props === null || props === void 0 ? void 0 : props.handler) !== null && _a !== void 0 ? _a : new lambda.Function(this, 'handler', {
            runtime: lambda.Runtime.PROVIDED,
            handler: 'index.php',
            layers: [
                lambda.LayerVersion.fromLayerVersionArn(this, 'BrefPHPLayer', BREF_LAYER_VERSION.PHP_74_FPM),
                vendorLayer,
            ],
            code: lambda.Code.fromAsset(path.join(__dirname, './php')),
            environment: {
                BREF_AUTOLOAD_PATH: '/opt/vendor/autoload.php',
            },
        });
        new apigateway.LambdaRestApi(this, 'apiservice', {
            handler: this.handler,
        });
    }
}
exports.ServerlessApi = ServerlessApi;
//# sourceMappingURL=data:application/json;base64,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