"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FlywayConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const awsLambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
// eslint-disable-next-line @typescript-eslint/no-require-imports
const pjson = require('../package.json');
/**
 * @stability stable
 */
class FlywayConstruct extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, params) {
        super(scope, id);
        /**
         * @stability stable
         */
        this.objectCodeKey = pjson.version;
        this.flywayLambdaMigration = new awsLambda.Function(this, id, {
            vpc: params.vpc,
            vpcSubnets: params.subnet,
            securityGroups: params.securityGroups,
            memorySize: params.memorySize || 512,
            timeout: params.timeout || cdk.Duration.seconds(30),
            handler: FlywayConstruct.HANDLER,
            runtime: awsLambda.Runtime.JAVA_11,
            environment: {
                //add PREFIX: params.bucketFolderPrefix || ''
                ARN: params.migrationDBSecretManager.secretArn,
                BUCKET_NAME: params.bucketMigrationSQL.bucketName,
            },
            code: awsLambda.S3Code.fromBucket(s3.Bucket.fromBucketArn(this, FlywayConstruct.ID_LAMBDA_CODE, FlywayConstruct.BUCKET_CODE_ARN), 'flywayjar.' + this.objectCodeKey + '.zip'),
        });
        params.migrationDBSecretManager.grantRead(this.flywayLambdaMigration);
        params.bucketMigrationSQL.grantRead(this.flywayLambdaMigration);
    }
}
exports.FlywayConstruct = FlywayConstruct;
_a = JSII_RTTI_SYMBOL_1;
FlywayConstruct[_a] = { fqn: "flywaymigrationconstruct.FlywayConstruct", version: "0.2.43" };
/**
 * @stability stable
 */
FlywayConstruct.HANDLER = 'tech.necko.flywayjar.Main::handleRequest';
/**
 * @stability stable
 */
FlywayConstruct.ID_LAMBDA_CODE = 'bucketMigration';
/**
 * @stability stable
 */
FlywayConstruct.BUCKET_CODE_ARN = 'arn:aws:s3:::flywaymigrationconstruct-cdk';
//# sourceMappingURL=data:application/json;base64,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