[Breakdance](http://breakdance.io/index.html)

* [Documentation](http://breakdance.io/docs.html)
* [Plugins](http://breakdance.io/plugins.html)
* [More](https://github.com/breakdance/breakdance) [Examples](http://breakdance.io/examples.html) [Recipes](http://breakdance.io/recipes.html) [Contributing](http://breakdance.io/contributing.html) [About](http://breakdance.io/about.html)

<br>
_It's time for your markup get down._

* [What is breakdance?](http://breakdance.io/#what-is-breakdance)
* [Quickstart](http://breakdance.io/#quickstart)
* [Next steps](http://breakdance.io/#next-steps)

## What is breakdance?

Breakdance is a node.js library for converting HTML to markdown.

**What's different about breakdance?**

Breakdance uses [cheerio](https://github.com/cheeriojs/cheerio) to parse HTML, and [snapdragon](https://github.com/jonschlinkert/snapdragon) for rendering, which provides comprehensive coverage of HTML 4 and 5 elements, and granular control over the entire conversion process in a way that is easy to understand, reason about, and [customize](http://breakdance.io/plugins.html).

**Why use breakdance?**

* Migrate HTML blog posts to markdown
* Convert wiki pages to markdown
* Convert HTML documentation to markdown
* Convert HTML presentations or slide decks to markdown

## Quickstart

**1. Install**

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save breakdance
```

Or install with [yarn](https://github.com/yarnpkg/yarn):

```sh
$ yarn add breakdance
```

**2. Convert some HTML!**

Add the following code to `example.js` then run `$ node example`:

```js
var breakdance = require('breakdance');
console.log(breakdance('<strong>The freaks come out at night!</strong>'));
//=> '**The freaks come out at night!**'
```

## Next steps

* Learn more about [using breakdance](http://breakdance.io/docs.html)
* See [HTML-to-markdown examples](http://breakdance.io/docs.html#examples)
* Visit the breakdance [unit tests](https://github.com/breakdance/breakdance/test), this is a great way to see comprehensive and detailed usage examples.

[breakdance](https://github.com/jonschlinkert/test) is maintained by [jonschlinkert](https://github.com/jonschlinkert). This site was generated by [Assemble](https://assemble.io/).
