| Element | Description |
| --- | --- |
| [`<dd>`](/en-US/docs/Web/HTML/Element/dd "The HTML <dd> element (or HTML Description Element) indicates the description of a term in a description list (<dl>).") | The **HTML `<dd>` element** (or _HTML Description Element_) indicates the description of a term in a description list ([`<dl>`](/en-US/docs/Web/HTML/Element/dl "The HTML <dl> element (or HTML Description List Element) encloses a list of groups of terms and descriptions. Common uses for this element are to implement a glossary or to display metadata (a list of key-value pairs).")). |
| [`<div>`](/en-US/docs/Web/HTML/Element/div "The HTML <div> element (or HTML Document Division Element) is the generic container for flow content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the class or id attributes), or because they share attribute values, such as lang. It should be used only when no other semantic element (such as <article> or <nav>) is appropriate.") | The **HTML `<div>` element** (or _HTML Document Division Element_) is the generic container for flow content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the **class** or **id** attributes), or because they share attribute values, such as **lang**. It should be used only when no other semantic element (such as [`<article>`](/en-US/docs/Web/HTML/Element/article "The HTML <article> element represents a self-contained composition in a document, page, application, or site, which is intended to be independently distributable or reusable (e.g., in syndication). This could be a forum post, a magazine or newspaper article, a blog entry, an object, or any other independent item of content. Each <article> should be identified, typically by including a heading (<h1>-<h6> element) as a child of the <article> element.") or [`<nav>`](/en-US/docs/Web/HTML/Element/nav "The HTML <nav> element (HTML Navigation Element) represents a section of a page that links to other pages or to parts within the page: a section with navigation links.")) is appropriate. |
| [`<dl>`](/en-US/docs/Web/HTML/Element/dl "The HTML <dl> element (or HTML Description List Element) encloses a list of groups of terms and descriptions. Common uses for this element are to implement a glossary or to display metadata (a list of key-value pairs).") | The **HTML `<dl>` element** (or _HTML_ _Description List Element_) encloses a list of groups of terms and descriptions. Common uses for this element are to implement a glossary or to display metadata (a list of key-value pairs). |
| [`<dt>`](/en-US/docs/Web/HTML/Element/dt "The HTML <dt> element (or HTML Description Term Element) identifies a term in a description list. This element can occur only as a child element of a <dl>. It is usually followed by a <dd> element; however, multiple <dt> elements in a row indicate several terms that are all defined by the immediate next <dd> element.") | The **HTML `<dt>` element** (or _HTML Description Term Element_) identifies a term in a description list. This element can occur only as a child element of a [`<dl>`](/en-US/docs/Web/HTML/Element/dl "The HTML <dl> element (or HTML Description List Element) encloses a list of groups of terms and descriptions. Common uses for this element are to implement a glossary or to display metadata (a list of key-value pairs)."). It is usually followed by a [`<dd>`](/en-US/docs/Web/HTML/Element/dd "The HTML <dd> element (HTML Description Element) indicates the description of a term in a description list (<dl>) element. This element can occur only as a child element of a description list and it must follow a <dt> element.") element; however, multiple `<dt>` elements in a row indicate several terms that are all defined by the immediate next [`<dd>`](/en-US/docs/Web/HTML/Element/dd "The HTML <dd> element (HTML Description Element) indicates the description of a term in a description list (<dl>) element. This element can occur only as a child element of a description list and it must follow a <dt> element.") element. |
| [`<figcaption>`](/en-US/docs/Web/HTML/Element/figcaption "The HTML <figcaption> element represents a caption or a legend associated with a figure or an illustration described by the rest of the data of the <figure> element which is its immediate ancestor which means <figcaption> can be the first or last element inside a <figure> block. Also, the HTML Figcaption Element is optional; if not provided, then the parent figure element will have no caption.") | The **HTML `<figcaption>` element** represents a caption or a legend associated with a figure or an illustration described by the rest of the data of the [`<figure>`](/en-US/docs/Web/HTML/Element/figure "The HTML <figure> element represents self-contained content, frequently with a caption (<figcaption>), and is typically referenced as a single unit. While it is related to the main flow, its position is independent of the main flow. Usually this is an image, an illustration, a diagram, a code snippet, or a schema that is referenced in the main text, but that can be moved to another page or to an appendix without affecting the main flow.") element which is its immediate ancestor which means `<figcaption>` can be the first or last element inside a [`<figure>`](/en-US/docs/Web/HTML/Element/figure "The HTML <figure> element represents self-contained content, frequently with a caption (<figcaption>), and is typically referenced as a single unit. While it is related to the main flow, its position is independent of the main flow. Usually this is an image, an illustration, a diagram, a code snippet, or a schema that is referenced in the main text, but that can be moved to another page or to an appendix without affecting the main flow.") block. Also, the _HTML Figcaption Element_ is optional; if not provided, then the parent figure element will have no caption. |
| [`<figure>`](/en-US/docs/Web/HTML/Element/figure "The HTML <figure> element represents self-contained content, frequently with a caption (<figcaption>), and is typically referenced as a single unit. While it is related to the main flow, its position is independent of the main flow. Usually this is an image, an illustration, a diagram, a code snippet, or a schema that is referenced in the main text, but that can be moved to another page or to an appendix without affecting the main flow.") | The **HTML `<figure>` element** represents self-contained content, frequently with a caption ([`<figcaption>`](/en-US/docs/Web/HTML/Element/figcaption "The HTML <figcaption> element represents a caption or a legend associated with a figure or an illustration described by the rest of the data of the <figure> element which is its immediate ancestor which means <figcaption> can be the first or last element inside a <figure> block. Also, the HTML Figcaption Element is optional; if not provided, then the parent figure element will have no caption.")) _`,`_ and is typically referenced as a single unit. While it is related to the main flow, its position is independent of the main flow. Usually this is an image, an illustration, a diagram, a code snippet, or a schema that is referenced in the main text, but that can be moved to another page or to an appendix without affecting the main flow. |
| [`<hr>`](/en-US/docs/Web/HTML/Element/hr "The HTML <hr> element represents a thematic break between paragraph-level elements (for example, a change of scene in a story, or a shift of topic with a section). In previous versions of HTML, it represented a horizontal rule. It may still be displayed as a horizontal rule in visual browsers, but is now defined in semantic terms, rather than presentational terms.") | The **HTML `<hr>` element** represents a thematic break between paragraph-level elements (for example, a change of scene in a story, or a shift of topic with a section). In previous versions of HTML, it represented a horizontal rule. It may still be displayed as a horizontal rule in visual browsers, but is now defined in semantic terms, rather than presentational terms. |
| [`<li>`](/en-US/docs/Web/HTML/Element/li "The HTML <li> element (or HTML List Item Element) is used to represent an item in a list. It must be contained in a parent element: an ordered list (<ol>), an unordered list (<ul>), or a menu (<menu>). In menus and unordered lists, list items are usually displayed using bullet points. In ordered lists, they are usually displayed with an ascending counter on the left, such as a number or letter.") | The **HTML `<li>` element** (or _HTML List Item Element_) is used to represent an item in a list. It must be contained in a parent element: an ordered list ([`<ol>`](/en-US/docs/Web/HTML/Element/ol "The HTML <ol> Element (or HTML Ordered List Element) represents an ordered list of items. Typically, ordered-list items are displayed with a preceding numbering, which can be of any form, like numerals, letters or Romans numerals or even simple bullets. This numbered style is not defined in the HTML description of the page, but in its associated CSS, using the list-style-type property.")), an unordered list ([`<ul>`](/en-US/docs/Web/HTML/Element/ul "The HTML <ul> element (or HTML Unordered List Element) represents an unordered list of items, namely a collection of items that do not have a numerical ordering, and their order in the list is meaningless. Typically, unordered-list items are displayed with a bullet, which can be of several forms, like a dot, a circle or a squared. The bullet style is not defined in the HTML description of the page, but in its associated CSS, using the list-style-type property.")), or a menu ([`<menu>`](/en-US/docs/Web/HTML/Element/menu "The HTML <menu> element represents a group of commands that a user can perform or activate. This includes both list menus, which might appear across the top of a screen, as well as context menus, such as those that might appear underneath a button after it has been clicked.")). In menus and unordered lists, list items are usually displayed using bullet points. In ordered lists, they are usually displayed with an ascending counter on the left, such as a number or letter. |
| [`<main>`](/en-US/docs/Web/HTML/Element/main "The HTML <main> element represents the main content of  the <body> of a document or application. The main content area consists of content that is directly related to, or expands upon the central topic of a document or the central functionality of an application. This content should be unique to the document, excluding any content that is repeated across a set of documents such as sidebars, navigation links, copyright information, site logos, and search forms (unless the document's main function is as a search form).") | The **HTML `<main>` element** represents the main content of  the [`<body>`](/en-US/docs/Web/HTML/Element/body "The HTML <body> Element represents the content of an HTML document. There can be only one <body> element in a document.") of a document or application. The main content area consists of content that is directly related to, or expands upon the central topic of a document or the central functionality of an application. This content should be unique to the document, excluding any content that is repeated across a set of documents such as sidebars, navigation links, copyright information, site logos, and search forms (unless the document's main function is as a search form). |
| [`<ol>`](/en-US/docs/Web/HTML/Element/ol "The HTML <ol> Element (or HTML Ordered List Element) represents an ordered list of items. Typically, ordered-list items are displayed with a preceding numbering, which can be of any form, like numerals, letters or Romans numerals or even simple bullets. This numbered style is not defined in the HTML description of the page, but in its associated CSS, using the list-style-type property.") | The **HTML `<ol>` Element** (or _HTML Ordered List Element_) represents an ordered list of items. Typically, ordered-list items are displayed with a preceding numbering, which can be of any form, like numerals, letters or Romans numerals or even simple bullets. This numbered style is not defined in the HTML description of the page, but in its associated CSS, using the [`list-style-type`](/en-US/docs/Web/CSS/list-style-type "The list-style-type property specifies the appearance of a list item element. Because it is the only property that defaults to display:list-item, this is usually a <li> element, but can be any element with this display value.") property. |
| [`<p>`](/en-US/docs/Web/HTML/Element/p "The HTML <p> element (or HTML Paragraph Element) represents a paragraph of text.") | The **HTML `<p>` element** (or _HTML Paragraph Element_) represents a paragraph of text. |
| [`<pre>`](/en-US/docs/Web/HTML/Element/pre "The HTML <pre> element (or HTML Preformatted Text) represents preformatted text. Text within this element is typically displayed in a non-proportional ("monospace") font exactly as it is laid out in the file. Whitespace inside this element is displayed as typed.") | The **HTML `<pre>` element** (or _HTML Preformatted Text_) represents preformatted text. Text within this element is typically displayed in a non-proportional ("[monospace](/en-US/docs/XUL/Style/monospace) ") font exactly as it is laid out in the file. Whitespace inside this element is displayed as typed. |
| [`<ul>`](/en-US/docs/Web/HTML/Element/ul "The HTML <ul> element (or HTML Unordered List Element) represents an unordered list of items, namely a collection of items that do not have a numerical ordering, and their order in the list is meaningless. Typically, unordered-list items are displayed with a bullet, which can be of several forms, like a dot, a circle or a squared. The bullet style is not defined in the HTML description of the page, but in its associated CSS, using the list-style-type property.") | The **HTML `<ul>` element** (or _HTML U_ _nordered List Element_ `)` represents an unordered list of items, namely a collection of items that do not have a numerical ordering, and their order in the list is meaningless. Typically, unordered-list items are displayed with a bullet, which can be of several forms, like a dot, a circle or a squared. The bullet style is not defined in the HTML description of the page, but in its associated CSS, using the [`list-style-type`](/en-US/docs/Web/CSS/list-style-type "The list-style-type property specifies the appearance of a list item element. Because it is the only property that defaults to display:list-item, this is usually a <li> element, but can be any element with this display value.") property. |
