import * as core from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * (experimental) Represents an IVS Playback Key Pair.
 *
 * @experimental
 */
export interface IPlaybackKeyPair extends core.IResource {
    /**
     * (experimental) Key-pair ARN.
     *
     * For example: arn:aws:ivs:us-west-2:693991300569:playback-key/f99cde61-c2b0-4df3-8941-ca7d38acca1a
     *
     * @experimental
     * @attribute true
     */
    readonly playbackKeyPairArn: string;
}
/**
 * Reference to a new or existing IVS Playback Key Pair
 */
declare abstract class PlaybackKeyPairBase extends core.Resource implements IPlaybackKeyPair {
    abstract readonly playbackKeyPairArn: string;
}
/**
 * (experimental) Properties for creating a new Playback Key Pair.
 *
 * @experimental
 */
export interface PlaybackKeyPairProps {
    /**
     * (experimental) The public portion of a customer-generated key pair.
     *
     * @experimental
     */
    readonly publicKeyMaterial: string;
    /**
     * (experimental) An arbitrary string (a nickname) assigned to a playback key pair that helps the customer identify that resource.
     *
     * The value does not need to be unique.
     *
     * @default None
     * @experimental
     */
    readonly name?: string;
}
/**
 * (experimental) A new IVS Playback Key Pair.
 *
 * @experimental
 */
export declare class PlaybackKeyPair extends PlaybackKeyPairBase {
    /**
     * (experimental) Key-pair ARN.
     *
     * For example: arn:aws:ivs:us-west-2:693991300569:playback-key/f99cde61-c2b0-4df3-8941-ca7d38acca1a
     *
     * @experimental
     */
    readonly playbackKeyPairArn: string;
    /**
     * (experimental) Key-pair identifier.
     *
     * For example: 98:0d:1a:a0:19:96:1e:ea:0a:0a:2c:9a:42:19:2b:e7
     *
     * @experimental
     * @attribute true
     */
    readonly playbackKeyPairFingerprint: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PlaybackKeyPairProps);
}
export {};
