"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseInstance = exports.InstanceType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
const cdk = require("aws-cdk-lib");
const endpoint_1 = require("./endpoint");
const aws_neptune_1 = require("aws-cdk-lib/aws-neptune");
/**
 * Possible Instances Types to use in Neptune cluster
 * used for defining {@link DatabaseInstanceProps.instanceType}.
 */
class InstanceType {
    constructor(instanceType) {
        if (cdk.Token.isUnresolved(instanceType) || instanceType.startsWith('db.')) {
            this._instanceType = instanceType;
        }
        else {
            throw new Error(`instance type must start with 'db.'; (got ${instanceType})`);
        }
    }
    /**
     * Build an InstanceType from given string or token, such as CfnParameter.
     */
    static of(instanceType) {
        return new InstanceType(instanceType);
    }
}
exports.InstanceType = InstanceType;
_a = JSII_RTTI_SYMBOL_1;
InstanceType[_a] = { fqn: "@aws-cdk/aws-neptune-alpha.InstanceType", version: "2.19.0-alpha.0" };
/**
 * db.r6g.large
 */
InstanceType.R6G_LARGE = InstanceType.of('db.r6g.large');
/**
 * db.r6g.xlarge
 */
InstanceType.R6G_XLARGE = InstanceType.of('db.r6g.xlarge');
/**
 * db.r6g.2xlarge
 */
InstanceType.R6G_2XLARGE = InstanceType.of('db.r6g.2xlarge');
/**
 * db.r6g.4xlarge
 */
InstanceType.R6G_4XLARGE = InstanceType.of('db.r6g.4xlarge');
/**
 * db.r6g.8xlarge
 */
InstanceType.R6G_8XLARGE = InstanceType.of('db.r6g.8xlarge');
/**
* db.r6g.12xlarge
*/
InstanceType.R6G_12XLARGE = InstanceType.of('db.r6g.12xlarge');
/**
 * db.r6g.16xlarge
 */
InstanceType.R6G_16XLARGE = InstanceType.of('db.r6g.16xlarge');
/**
 * db.t4g.medium
 */
InstanceType.T4G_MEDIUM = InstanceType.of('db.t4g.medium');
/**
 * db.r5.large
 */
InstanceType.R5_LARGE = InstanceType.of('db.r5.large');
/**
 * db.r5.xlarge
 */
InstanceType.R5_XLARGE = InstanceType.of('db.r5.xlarge');
/**
 * db.r5.2xlarge
 */
InstanceType.R5_2XLARGE = InstanceType.of('db.r5.2xlarge');
/**
 * db.r5.4xlarge
 */
InstanceType.R5_4XLARGE = InstanceType.of('db.r5.4xlarge');
/**
 * db.r5.8xlarge
 */
InstanceType.R5_8XLARGE = InstanceType.of('db.r5.8xlarge');
/**
 * db.r5.12xlarge
 */
InstanceType.R5_12XLARGE = InstanceType.of('db.r5.12xlarge');
/**
 * db.r5.24xlarge
 */
InstanceType.R5_24XLARGE = InstanceType.of('db.r5.24xlarge');
/**
 * db.r4.large
 */
InstanceType.R4_LARGE = InstanceType.of('db.r4.large');
/**
 * db.r4.xlarge
 */
InstanceType.R4_XLARGE = InstanceType.of('db.r4.xlarge');
/**
 * db.r4.2xlarge
 */
InstanceType.R4_2XLARGE = InstanceType.of('db.r4.2xlarge');
/**
 * db.r4.4xlarge
 */
InstanceType.R4_4XLARGE = InstanceType.of('db.r4.4xlarge');
/**
 * db.r4.8xlarge
 */
InstanceType.R4_8XLARGE = InstanceType.of('db.r4.8xlarge');
/**
 * db.t3.medium
 */
InstanceType.T3_MEDIUM = InstanceType.of('db.t3.medium');
/**
 * A database instance
 *
 * @resource AWS::Neptune::DBInstance
 */
class DatabaseInstance extends cdk.Resource {
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_neptune_alpha_DatabaseInstanceProps(props);
        const instance = new aws_neptune_1.CfnDBInstance(this, 'Resource', {
            dbClusterIdentifier: props.cluster.clusterIdentifier,
            dbInstanceClass: props.instanceType._instanceType,
            availabilityZone: props.availabilityZone,
            dbInstanceIdentifier: props.dbInstanceName,
            dbParameterGroupName: (_c = props.parameterGroup) === null || _c === void 0 ? void 0 : _c.parameterGroupName,
        });
        this.cluster = props.cluster;
        this.instanceIdentifier = instance.ref;
        this.dbInstanceEndpointAddress = instance.attrEndpoint;
        this.dbInstanceEndpointPort = instance.attrPort;
        // create a number token that represents the port of the instance
        const portAttribute = cdk.Token.asNumber(instance.attrPort);
        this.instanceEndpoint = new endpoint_1.Endpoint(instance.attrEndpoint, portAttribute);
        instance.applyRemovalPolicy(props.removalPolicy, {
            applyToUpdateReplacePolicy: true,
        });
    }
    /**
     * Import an existing database instance.
     */
    static fromDatabaseInstanceAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_neptune_alpha_DatabaseInstanceAttributes(attrs);
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.defaultPort = ec2.Port.tcp(attrs.port);
                this.instanceIdentifier = attrs.instanceIdentifier;
                this.dbInstanceEndpointAddress = attrs.instanceEndpointAddress;
                this.dbInstanceEndpointPort = attrs.port.toString();
                this.instanceEndpoint = new endpoint_1.Endpoint(attrs.instanceEndpointAddress, attrs.port);
            }
        }
        return new Import(scope, id);
    }
}
exports.DatabaseInstance = DatabaseInstance;
_b = JSII_RTTI_SYMBOL_1;
DatabaseInstance[_b] = { fqn: "@aws-cdk/aws-neptune-alpha.DatabaseInstance", version: "2.19.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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