import * as iam from '@aws-cdk/aws-iam';
import * as sns from '@aws-cdk/aws-sns';
import * as cdk from '@aws-cdk/core';
import { MessageLanguage } from './common';
import { CloudFormationRuleConstraintOptions, CommonConstraintOptions, StackSetsConstraintOptions, TagUpdateConstraintOptions } from './constraints';
import { IProduct } from './product';
import { TagOptions } from './tag-options';
import { Construct } from 'constructs';
/**
 * (experimental) Options for portfolio share.
 *
 * @experimental
 */
export interface PortfolioShareOptions {
    /**
     * (experimental) Whether to share tagOptions as a part of the portfolio share.
     *
     * @default - share not specified
     * @experimental
     */
    readonly shareTagOptions?: boolean;
    /**
     * (experimental) The message language of the share.
     *
     * Controls status and error message language for share.
     *
     * @default - English
     * @experimental
     */
    readonly messageLanguage?: MessageLanguage;
}
/**
 * (experimental) A Service Catalog portfolio.
 *
 * @experimental
 */
export interface IPortfolio extends cdk.IResource {
    /**
     * (experimental) The ARN of the portfolio.
     *
     * @experimental
     * @attribute true
     */
    readonly portfolioArn: string;
    /**
     * (experimental) The ID of the portfolio.
     *
     * @experimental
     * @attribute true
     */
    readonly portfolioId: string;
    /**
     * (experimental) Associate portfolio with an IAM Role.
     *
     * @param role an IAM role.
     * @experimental
     */
    giveAccessToRole(role: iam.IRole): void;
    /**
     * (experimental) Associate portfolio with an IAM User.
     *
     * @param user an IAM user.
     * @experimental
     */
    giveAccessToUser(user: iam.IUser): void;
    /**
     * (experimental) Associate portfolio with an IAM Group.
     *
     * @param group an IAM Group.
     * @experimental
     */
    giveAccessToGroup(group: iam.IGroup): void;
    /**
     * (experimental) Initiate a portfolio share with another account.
     *
     * @param accountId AWS account to share portfolio with.
     * @param options Options for the initiate share.
     * @experimental
     */
    shareWithAccount(accountId: string, options?: PortfolioShareOptions): void;
    /**
     * (experimental) Associate portfolio with the given product.
     *
     * @param product A service catalog produt.
     * @experimental
     */
    addProduct(product: IProduct): void;
    /**
     * (experimental) Associate Tag Options.
     *
     * A TagOption is a key-value pair managed in AWS Service Catalog.
     * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
     *
     * @experimental
     */
    associateTagOptions(tagOptions: TagOptions): void;
    /**
     * (experimental) Add a Resource Update Constraint.
     *
     * @experimental
     */
    constrainTagUpdates(product: IProduct, options?: TagUpdateConstraintOptions): void;
    /**
     * (experimental) Add notifications for supplied topics on the provisioned product.
     *
     * @param product A service catalog product.
     * @param topic A SNS Topic to receive notifications on events related to the provisioned product.
     * @experimental
     */
    notifyOnStackEvents(product: IProduct, topic: sns.ITopic, options?: CommonConstraintOptions): void;
    /**
     * (experimental) Set provisioning rules for the product.
     *
     * @param product A service catalog product.
     * @param options options for the constraint.
     * @experimental
     */
    constrainCloudFormationParameters(product: IProduct, options: CloudFormationRuleConstraintOptions): void;
    /**
     * (experimental) Force users to assume a certain role when launching a product.
     *
     * @param product A service catalog product.
     * @param launchRole The IAM role a user must assume when provisioning the product.
     * @param options options for the constraint.
     * @experimental
     */
    setLaunchRole(product: IProduct, launchRole: iam.IRole, options?: CommonConstraintOptions): void;
    /**
     * (experimental) Configure deployment options using AWS Cloudformaiton StackSets.
     *
     * @param product A service catalog product.
     * @param options Configuration options for the constraint.
     * @experimental
     */
    deployWithStackSets(product: IProduct, options: StackSetsConstraintOptions): void;
}
declare abstract class PortfolioBase extends cdk.Resource implements IPortfolio {
    abstract readonly portfolioArn: string;
    abstract readonly portfolioId: string;
    private readonly associatedPrincipals;
    /**
     * (experimental) Associate portfolio with an IAM Role.
     *
     * @experimental
     */
    giveAccessToRole(role: iam.IRole): void;
    /**
     * (experimental) Associate portfolio with an IAM User.
     *
     * @experimental
     */
    giveAccessToUser(user: iam.IUser): void;
    /**
     * (experimental) Associate portfolio with an IAM Group.
     *
     * @experimental
     */
    giveAccessToGroup(group: iam.IGroup): void;
    /**
     * (experimental) Associate portfolio with the given product.
     *
     * @experimental
     */
    addProduct(product: IProduct): void;
    /**
     * (experimental) Initiate a portfolio share with another account.
     *
     * @experimental
     */
    shareWithAccount(accountId: string, options?: PortfolioShareOptions): void;
    /**
     * (experimental) Associate Tag Options.
     *
     * A TagOption is a key-value pair managed in AWS Service Catalog.
     * It is not an AWS tag, but serves as a template for creating an AWS tag based on the TagOption.
     *
     * @experimental
     */
    associateTagOptions(tagOptions: TagOptions): void;
    /**
     * (experimental) Add a Resource Update Constraint.
     *
     * @experimental
     */
    constrainTagUpdates(product: IProduct, options?: TagUpdateConstraintOptions): void;
    /**
     * (experimental) Add notifications for supplied topics on the provisioned product.
     *
     * @experimental
     */
    notifyOnStackEvents(product: IProduct, topic: sns.ITopic, options?: CommonConstraintOptions): void;
    /**
     * (experimental) Set provisioning rules for the product.
     *
     * @experimental
     */
    constrainCloudFormationParameters(product: IProduct, options: CloudFormationRuleConstraintOptions): void;
    /**
     * (experimental) Force users to assume a certain role when launching a product.
     *
     * @experimental
     */
    setLaunchRole(product: IProduct, launchRole: iam.IRole, options?: CommonConstraintOptions): void;
    /**
     * (experimental) Configure deployment options using AWS Cloudformaiton StackSets.
     *
     * @experimental
     */
    deployWithStackSets(product: IProduct, options: StackSetsConstraintOptions): void;
    /**
     * Associate a principal with the portfolio.
     * If the principal is already associated, it will skip.
     */
    private associatePrincipal;
    /**
     * Create a unique id based off the L1 CfnPortfolio or the arn of an imported portfolio.
     */
    protected abstract generateUniqueHash(value: string): string;
}
/**
 * (experimental) Properties for a Portfolio.
 *
 * @experimental
 */
export interface PortfolioProps {
    /**
     * (experimental) The name of the portfolio.
     *
     * @experimental
     */
    readonly displayName: string;
    /**
     * (experimental) The provider name.
     *
     * @experimental
     */
    readonly providerName: string;
    /**
     * (experimental) The message language.
     *
     * Controls language for
     * status logging and errors.
     *
     * @default - English
     * @experimental
     */
    readonly messageLanguage?: MessageLanguage;
    /**
     * (experimental) Description for portfolio.
     *
     * @default - No description provided
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) TagOptions associated directly on portfolio.
     *
     * @default - No tagOptions provided
     * @experimental
     */
    readonly tagOptions?: TagOptions;
}
/**
 * (experimental) A Service Catalog portfolio.
 *
 * @experimental
 */
export declare class Portfolio extends PortfolioBase {
    /**
     * (experimental) Creates a Portfolio construct that represents an external portfolio.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param portfolioArn the Amazon Resource Name of the existing portfolio.
     * @experimental
     */
    static fromPortfolioArn(scope: Construct, id: string, portfolioArn: string): IPortfolio;
    /**
     * (experimental) The ARN of the portfolio.
     *
     * @experimental
     */
    readonly portfolioArn: string;
    /**
     * (experimental) The ID of the portfolio.
     *
     * @experimental
     */
    readonly portfolioId: string;
    private readonly portfolio;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: PortfolioProps);
    /**
     * (experimental) Create a unique id based off the L1 CfnPortfolio or the arn of an imported portfolio.
     *
     * @experimental
     */
    protected generateUniqueHash(value: string): string;
    private validatePortfolioProps;
}
export {};
