import * as cdk8s from 'cdk8s';
import { Construct } from 'constructs';
/**
 * Initialization properties for resources.
 *
 * @stability stable
 */
export interface ResourceProps {
    /**
     * Metadata that all persisted resources must have, which includes all objects users must create.
     *
     * @stability stable
     */
    readonly metadata?: cdk8s.ApiObjectMetadata;
}
/**
 * Represents a resource.
 *
 * @stability stable
 */
export interface IResource {
    /**
     * The Kubernetes name of this resource.
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Base class for all Kubernetes objects in stdk8s.
 *
 * Represents a single
 * resource.
 *
 * @stability stable
 */
export declare abstract class Resource extends Construct implements IResource {
    /**
     * The underlying cdk8s API object.
     *
     * @stability stable
     */
    protected abstract readonly apiObject: cdk8s.ApiObject;
    /**
     * @stability stable
     */
    get metadata(): cdk8s.ApiObjectMetadataDefinition;
    /**
     * The name of this API object.
     *
     * @stability stable
     */
    get name(): string;
}
