# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2018-01-17 15:28
from __future__ import unicode_literals

import codenerix.models_people
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('codenerix_geodata', '0002_auto_20170921_1206'),
    ]

    operations = [
        migrations.CreateModel(
            name='Storage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('alias', models.CharField(blank=True, max_length=100, null=True, verbose_name='Alias')),
                ('town', models.CharField(blank=True, max_length=250, null=True, verbose_name='Town')),
                ('zipcode', models.CharField(blank=True, max_length=6, null=True, verbose_name='Zip code')),
                ('address', models.CharField(blank=True, max_length=250, null=True, verbose_name='Address')),
                ('phone', models.CharField(blank=True, max_length=16, null=True, verbose_name='Phone')),
                ('name', models.CharField(max_length=80, verbose_name='Storage')),
                ('city', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='codenerix_storages_storage_geo_addresses', to='codenerix_geodata.City', verbose_name='City')),
                ('country', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='codenerix_storages_storage_geo_addresses', to='codenerix_geodata.Country', verbose_name='Country')),
                ('province', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='codenerix_storages_storage_geo_addresses', to='codenerix_geodata.Province', verbose_name='Province')),
                ('region', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='codenerix_storages_storage_geo_addresses', to='codenerix_geodata.Region', verbose_name='Region')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StorageBox',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('name', models.CharField(max_length=80, verbose_name='Name')),
                ('weight', models.FloatField(blank=True, null=True, verbose_name='Weight')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StorageBoxKind',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('length', models.FloatField(blank=True, null=True, verbose_name='Length')),
                ('width', models.FloatField(blank=True, null=True, verbose_name='Width')),
                ('heigth', models.FloatField(blank=True, null=True, verbose_name='Heigth')),
                ('weight', models.FloatField(blank=True, null=True, verbose_name='Weight')),
                ('max_weight', models.FloatField(blank=True, null=True, verbose_name='Weight')),
                ('name', models.CharField(max_length=80, verbose_name='Name')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StorageBoxStructure',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('length', models.FloatField(blank=True, null=True, verbose_name='Length')),
                ('width', models.FloatField(blank=True, null=True, verbose_name='Width')),
                ('heigth', models.FloatField(blank=True, null=True, verbose_name='Heigth')),
                ('weight', models.FloatField(blank=True, null=True, verbose_name='Weight')),
                ('max_weight', models.FloatField(blank=True, null=True, verbose_name='Weight')),
                ('name', models.CharField(max_length=80, verbose_name='Name')),
                ('box_structure', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='storage_boxes_structure', to='codenerix_storages.StorageBoxStructure', verbose_name='Structure box')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StorageOperator',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('enable', models.BooleanField(default=True, verbose_name='Enable')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
            bases=(codenerix.models_people.GenRole, models.Model),
        ),
        migrations.CreateModel(
            name='StorageZone',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('name', models.CharField(max_length=80, verbose_name='Zone')),
                ('salable', models.BooleanField(default=True, verbose_name='Salable')),
                ('storage', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='storage_zones', to='codenerix_storages.Storage', verbose_name='Storage')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='storageoperator',
            name='zone',
            field=models.ManyToManyField(related_name='storage_operators', to='codenerix_storages.StorageZone', verbose_name='Zones'),
        ),
        migrations.AddField(
            model_name='storageboxstructure',
            name='zone',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='storage_boxes_structure', to='codenerix_storages.StorageZone', verbose_name='Zone'),
        ),
        migrations.AddField(
            model_name='storagebox',
            name='box_kind',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='storage_boxes', to='codenerix_storages.StorageBoxKind', verbose_name='Box Kind'),
        ),
        migrations.AddField(
            model_name='storagebox',
            name='box_structure',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='storage_boxes', to='codenerix_storages.StorageBoxStructure', verbose_name='Box Structure'),
        ),
    ]
