# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2018-01-18 16:24
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ('codenerix_products', '0006_auto_20180118_1126'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('codenerix_storages', '0005_auto_20180118_1417'),
    ]

    operations = [
        migrations.CreateModel(
            name='IncomingAlbaran',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('code', models.CharField(max_length=64, verbose_name='Code')),
                ('code_counter', models.IntegerField(editable=False, verbose_name='Code counter')),
                ('reception_date', models.DateTimeField(blank=True, null=True, verbose_name='Reception Date')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Inventory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('name', models.CharField(max_length=80, verbose_name='Name')),
                ('opened', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='Date')),
                ('closed', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='Date')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InventoryAlbaran',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('name', models.CharField(max_length=80, verbose_name='Name')),
                ('opened', models.DateTimeField(default=django.utils.timezone.now, editable=False, verbose_name='Date')),
                ('closed', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='Date')),
                ('inventory', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='storage_inventoryalbarans', to='codenerix_storages.Inventory', verbose_name='Inventory')),
                ('storage_operator', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='storage_inventoryalbarans', to='codenerix_storages.StorageOperator', verbose_name='Storage Operator')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='InventoryAlbaranLine',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('inventory_albaran', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='storage_inventoryalbaranlines', to='codenerix_storages.InventoryAlbaran', verbose_name='Inventory Albaran')),
                ('product_unique', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='storage_inventoryalbaranlines', to='codenerix_products.ProductUnique', verbose_name='Product')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LineIncomingAlbaran',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('quantity', models.FloatField(verbose_name='Quantity')),
                ('box', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='line_ingoming_albarans', to='codenerix_storages.StorageBox', verbose_name='Box')),
                ('incoming_albaran', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='line_incoming_albarans', to='codenerix_storages.IncomingAlbaran', verbose_name='Incoming Albaran')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LineOutgoingAlbaran',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LineRequestStock',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('quantity', models.FloatField(verbose_name='Quantity')),
                ('product_final', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='line_request_stock', to='codenerix_products.ProductFinal', verbose_name='Product')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OutgoingAlbaran',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('code', models.CharField(max_length=64, verbose_name='Code')),
                ('code_counter', models.IntegerField(editable=False, verbose_name='Code counter')),
                ('prepare_date', models.DateTimeField(verbose_name='Prepare Date')),
                ('outgoing_date', models.DateTimeField(blank=True, null=True, verbose_name='Outgoing Date')),
                ('estimated_date', models.DateTimeField(blank=True, null=True, verbose_name='Estimated Date')),
                ('prepare_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='outgoing_albarans', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='RequestStock',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated')),
                ('code', models.CharField(max_length=64, verbose_name='Code')),
                ('code_counter', models.IntegerField(editable=False, verbose_name='Code counter')),
                ('request_date', models.DateTimeField(verbose_name='Request Date')),
                ('desired_date', models.DateTimeField(verbose_name='Desired Date')),
                ('request_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='request_stocks', to=settings.AUTH_USER_MODEL)),
                ('storage_destination', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='request_stocks_dst', to='codenerix_storages.Storage', verbose_name='Storage destionation')),
                ('storage_source', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='request_stocks_src', to='codenerix_storages.Storage', verbose_name='Storage source')),
            ],
            options={
                'default_permissions': ('add', 'change', 'delete', 'view', 'list'),
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='outgoingalbaran',
            name='request_stock',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='outgoing_albarans', to='codenerix_storages.RequestStock', verbose_name='Request stock'),
        ),
        migrations.AddField(
            model_name='linerequeststock',
            name='request_stock',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='line_request_stock', to='codenerix_storages.RequestStock', verbose_name='Request stock'),
        ),
        migrations.AddField(
            model_name='lineoutgoingalbaran',
            name='outgoing_albaran',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='line_outgoing_albarans', to='codenerix_storages.OutgoingAlbaran', verbose_name='Outgoing Albaran'),
        ),
        migrations.AddField(
            model_name='lineoutgoingalbaran',
            name='prepare_user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='line_outgoing_albarans_prepare', to=settings.AUTH_USER_MODEL, verbose_name='Prepare user'),
        ),
        migrations.AddField(
            model_name='lineoutgoingalbaran',
            name='product_unique',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='line_outgoing_albarans', to='codenerix_products.ProductUnique', verbose_name='Outgoing Albaran'),
        ),
        migrations.AddField(
            model_name='lineoutgoingalbaran',
            name='validator_user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='line_outgoing_albarans_validator', to=settings.AUTH_USER_MODEL, verbose_name='Validator user'),
        ),
        migrations.AddField(
            model_name='lineincomingalbaran',
            name='product_unique',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='line_incoming_albarans', to='codenerix_storages.OutgoingAlbaran', verbose_name='Product'),
        ),
        migrations.AddField(
            model_name='lineincomingalbaran',
            name='validator_user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='line_incoming_albarans', to=settings.AUTH_USER_MODEL, verbose_name='Validator user'),
        ),
        migrations.AddField(
            model_name='incomingalbaran',
            name='outgoing_albaran',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='incoming_albarans', to='codenerix_storages.OutgoingAlbaran', verbose_name='Outgoing Albaran'),
        ),
        migrations.AddField(
            model_name='incomingalbaran',
            name='reception_user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='incoming_albarans', to=settings.AUTH_USER_MODEL, verbose_name='Reception user'),
        ),
    ]
