// Copyright (c) Mito
import React from 'react';
import '../../../css/elements/TextButton.css';
import { classNames } from '../../utils/classNames';
/**
 *
 * The TextButton component is a rectangular, colored button that contains centered text.
 *
 * By default, it relies on the HTML button, but if the href param is supplied, it will use
 * the anchor tag instead.
 *
 */
const TextButton = (props) => {
    // Create better default values to handle optional params 
    const disabled = props.disabled === true;
    const width = props.width || 'block';
    const className = props.className || '';
    // Create css classes to apply
    const disabledClass = disabled ? 'text-button-disabled' : '';
    const widthClass = `element-width-${width}`;
    const variantClass = `text-button-variant-${props.variant}`;
    if (props.href !== undefined) {
        return (React.createElement("a", { className: classNames('text-button', 'text-header-3', 'text-overflow-wrap', widthClass, variantClass, disabledClass, className), 
            /*
                Because anchor tags don't handle the disabled keyword, we check that the element
                is not disabled before taking any action.
            */
            href: disabled ? undefined : props.href, download: disabled ? undefined : props.download, onClick: disabled ? () => { return; } : props.onClick, target: props.target, title: props.disabled && props.disabledTooltip ? props.disabledTooltip : undefined }, props.children));
    }
    else {
        return (React.createElement("button", { className: classNames('text-button', widthClass, variantClass, disabledClass), onClick: props.onClick, type: props.type, disabled: props.disabled, autoFocus: props.autoFocus, title: props.disabled && props.disabledTooltip ? props.disabledTooltip : undefined }, props.children));
    }
};
export default TextButton;
//# sourceMappingURL=TextButton.js.map