// Copyright (c) Mito
import React from 'react';
// import css
import '../../../css/elements/Toggle.css';
import { classNames } from '../../utils/classNames';
/**
 * The Toggle component. Allows the user to toggle something between On and Off.
 *
 * The Toggle component utilizes the html input element with a type checkbox, so that we
 * follow the design patterns of html elements. In order to create our custom designed toggle,
 * we hide the default html checkbox and style the label property.
 *
 * Inspired by: https://stackoverflow.com/questions/39846282/how-to-add-the-text-on-and-off-to-toggle-button and
 * https://www.youtube.com/watch?v=N8BZvfRD_eU
 */
const Toggle = (props) => {
    const disabled = props.disabled === true;
    const className = props.className !== undefined ? props.className : '';
    return (React.createElement("label", { className: classNames("toggle-label", className), style: props.height ? { "--toggle-height": props.height } : {} },
        React.createElement("input", { type: "checkbox", checked: props.value, onClick: () => {
                if (disabled) {
                    return;
                }
                props.onChange();
            } }),
        React.createElement("div", { className: classNames("toggle", { 'toggle-disabled': disabled }) })));
};
export default Toggle;
//# sourceMappingURL=Toggle.js.map