// Copyright (c) Mito
import React, { useEffect } from 'react';
import { getRandomId } from '../../jupyter/api';
import { GraphSidebarTab } from '../../types';
import Dropdown from '../elements/Dropdown';
import DropdownItem from '../elements/DropdownItem';
import DropdownSectionSeperator from '../elements/DropdownSectionSeperator';
import { TaskpaneType } from '../taskpanes/taskpanes';
/*
    Displays a set of actions one can perform on a graph sheet tab, including
    deleting, duplicating, or renaming.
*/
export default function GraphSheetTabActions(props) {
    // Log opening the graph sheet tab actions
    useEffect(() => {
        if (props.display) {
            void props.mitoAPI.log('clicked_graph_sheet_tab_actions', {
                graph_id: props.graphID
            });
        }
    }, [props.display]);
    const onDelete = async () => {
        // Close 
        props.closeOpenEditingPopups();
        await props.mitoAPI.editGraphDelete(props.graphID);
    };
    const onDuplicate = async () => {
        // Close 
        props.closeOpenEditingPopups();
        // Duplicate the graph
        const newGraphID = getRandomId();
        await props.mitoAPI.editGraphDuplicate(props.graphID, newGraphID);
    };
    /* Rename helper, which requires changes to the sheet tab itself */
    const onRename = () => {
        props.setIsRename(true);
    };
    const openExportGraphTaskpaneTab = async () => {
        props.setUIState(prevUIState => {
            return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: {
                    type: TaskpaneType.GRAPH,
                    graphID: props.graphID,
                    graphSidebarTab: GraphSidebarTab.Export
                } });
        });
    };
    return (React.createElement(Dropdown, { display: props.display, closeDropdown: () => props.setDisplayActions(false), width: 'small' },
        React.createElement(DropdownItem, { title: 'Export', onClick: (e) => {
                // Stop propogation so that the onClick of the sheet tab div
                // doesn't compete setting the currOpenTaskpane
                e === null || e === void 0 ? void 0 : e.stopPropagation();
                void openExportGraphTaskpaneTab();
            } }),
        React.createElement(DropdownSectionSeperator, { isDropdownSectionSeperator: true }),
        React.createElement(DropdownItem, { title: 'Duplicate', onClick: onDuplicate }),
        React.createElement(DropdownItem, { title: 'Rename', onClick: onRename, supressFocusSettingOnClose: true }),
        React.createElement(DropdownItem, { title: 'Delete', onClick: (e) => {
                // Stop propogation so that the onClick of the sheet tab div
                // doesn't compete updating the uiState to the graphID that is getting deleted
                e === null || e === void 0 ? void 0 : e.stopPropagation();
                void onDelete();
            } })));
}
//# sourceMappingURL=GraphSheetTabActions.js.map