// Copyright (c) Mito
import React from 'react';
import { isNumberDtype } from '../../../../utils/dtypes';
import { getColumnFormatDropdownItemsUsingColumnID, getFormatTitle } from '../../../../utils/formatColumns';
import Select from '../../../elements/Select';
import Col from '../../../layout/Col';
import Row from '../../../layout/Row';
// Displayed if the user hovers over this section
const FORMAT_DESCRIPTION = 'Format the selected column as a percent, choose the number of decimals, etc. This only changes the display of the column, and does not effect the underlying dataframe.';
/*
    A card that allows a user to change
    the format of a column
*/
function FormatCard(props) {
    var _a;
    const formatTypeTitle = getFormatTitle((_a = props.sheetData) === null || _a === void 0 ? void 0 : _a.columnFormatTypeObjMap[props.columnID]);
    return (React.createElement(React.Fragment, null,
        React.createElement(Row, { justify: 'space-between', align: 'center' },
            React.createElement(Col, { span: 4, title: FORMAT_DESCRIPTION },
                React.createElement("p", { className: 'text-header-3', title: '' }, "Format")),
            React.createElement(Col, { offset: 2, flex: '1' },
                isNumberDtype(props.columnDtype) &&
                    React.createElement(Select, { value: formatTypeTitle }, getColumnFormatDropdownItemsUsingColumnID(props.gridState.sheetIndex, props.columnID, props.mitoAPI, props.columnDtype, props.sheetData)),
                !isNumberDtype(props.columnDtype) &&
                    React.createElement("p", { className: 'text-header-3 text-align-right' }, formatTypeTitle))),
        !isNumberDtype(props.columnDtype) &&
            React.createElement(Row, null,
                React.createElement(Col, null,
                    React.createElement("p", { className: 'text-subtext-1' }, "Mito only supports formatting columns with dtype int or float.")))));
}
export default FormatCard;
//# sourceMappingURL=FormatCard.js.map