import React from "react";
import ExcelFormatSection from "../../../pro/download/ExcelFormatSection";
import { toggleInArray } from "../../../utils/arrays";
import MultiToggleBox from "../../elements/MultiToggleBox";
import MultiToggleItem from "../../elements/MultiToggleItem";
import Row from "../../layout/Row";
const ExcelDownloadConfigSection = (props) => {
    return (React.createElement(React.Fragment, null,
        React.createElement("p", { className: 'text-header-3' }, "Dataframes to Export"),
        React.createElement(MultiToggleBox, { width: 'block', height: 'small' }, props.dfNames.map((dfName, index) => {
            return (React.createElement(MultiToggleItem, { key: index, title: dfName, toggled: props.exportState.sheetIndexes.includes(index), index: index, onToggle: () => {
                    props.setUIState(prevUIState => {
                        const newSheetIndexes = [...props.exportState.sheetIndexes];
                        toggleInArray(newSheetIndexes, index); // Toggle the index
                        newSheetIndexes.sort(); // Make sure these are in the right order;
                        return Object.assign(Object.assign({}, prevUIState), { exportConfiguration: { exportType: 'excel', sheetIndexes: newSheetIndexes } });
                    });
                } }));
        })),
        props.userProfile.isPro &&
            React.createElement(ExcelFormatSection, { dfNames: props.dfNames, mitoAPI: props.mitoAPI, sheetDataArray: props.sheetDataArray, exportState: props.exportState, newlyFormattedColumns: props.newlyFormattedColumns, setNewlyFormattedColumns: props.setNewlyFormattedColumns }),
        !props.userProfile.isPro &&
            React.createElement(Row, { justify: 'space-around' },
                React.createElement("p", { className: 'ma-25px text-align-center text-body-1' },
                    "Want to preserving your formatting when exporting to Excel? Consider upgrading to\u00A0",
                    React.createElement("a", { onClick: () => void props.mitoAPI.log('clicked_pro_button', {
                            'pro_button_location': 'download_taskpane_excel_format_export',
                        }), className: 'text-body-1-link', href: 'https://www.trymito.io/plans', target: '_blank', rel: "noreferrer" }, "Mito Pro"),
                    "."))));
};
export default ExcelDownloadConfigSection;
//# sourceMappingURL=ExcelDownloadConfigSection.js.map