// Copyright (c) Mito
import React from 'react';
import useLiveUpdatingParams from '../../../hooks/useLiveUpdatingParams';
import { StepType } from '../../../types';
import { getDisplayColumnHeader } from '../../../utils/columnHeaders';
import DropdownItem from '../../elements/DropdownItem';
import MultiToggleBox from '../../elements/MultiToggleBox';
import MultiToggleItem from '../../elements/MultiToggleItem';
import Select from '../../elements/Select';
import Col from '../../layout/Col';
import Row from '../../layout/Row';
import { getDtypeValue } from '../ControlPanel/FilterAndSortTab/DtypeCard';
import DefaultEmptyTaskpane from '../DefaultTaskpane/DefaultEmptyTaskpane';
import DefaultTaskpane from '../DefaultTaskpane/DefaultTaskpane';
import DefaultTaskpaneBody from '../DefaultTaskpane/DefaultTaskpaneBody';
import DefaultTaskpaneHeader from '../DefaultTaskpane/DefaultTaskpaneHeader';
import { getFirstSuggestedMergeKeys } from './mergeUtils';
import MergeSheetSection from './MergeSheetSelection';
import MergeKeysSelectionSection from './MergeKeysSelection';
import { addIfAbsent, removeIfPresent, toggleInArray } from '../../../utils/arrays';
import Spacer from '../../layout/Spacer';
// Enum to allow you to refer to the first or second sheet by name, for clarity
export var MergeSheet;
(function (MergeSheet) {
    MergeSheet[MergeSheet["First"] = 0] = "First";
    MergeSheet[MergeSheet["Second"] = 1] = "Second";
})(MergeSheet || (MergeSheet = {}));
/*
    Each entry of this enum is a merge type that the user can choose.
    In all cases, except lookup, these values are passed directly to
    the pandas merge function.
*/
export var MergeType;
(function (MergeType) {
    MergeType["LOOKUP"] = "lookup";
    MergeType["LEFT"] = "left";
    MergeType["RIGHT"] = "right";
    MergeType["INNER"] = "inner";
    MergeType["OUTER"] = "outer";
    MergeType["UNIQUE_IN_LEFT"] = "unique in left";
    MergeType["UNIQUE_IN_RIGHT"] = "unique in right";
})(MergeType || (MergeType = {}));
export const getDefaultMergeParams = (sheetDataArray, _sheetIndexOne, _sheetIndexTwo, previousParams) => {
    var _a, _b;
    if (sheetDataArray.length < 2) {
        return undefined;
    }
    const sheetIndexOne = _sheetIndexOne;
    const sheetIndexTwo = _sheetIndexTwo !== undefined
        ? _sheetIndexTwo
        : (sheetIndexOne + 1 <= sheetDataArray.length - 1
            ? sheetIndexOne + 1
            : (sheetIndexOne - 1 >= 0 ? sheetIndexOne - 1 : sheetIndexOne));
    // If we didn't change the sheets, then the default params are just the params we had last
    if (previousParams && previousParams.sheet_index_one == sheetIndexOne && previousParams.sheet_index_two === sheetIndexTwo) {
        return previousParams;
    }
    const suggestedMergeKeys = getFirstSuggestedMergeKeys(sheetDataArray, sheetIndexOne, sheetIndexTwo);
    // We default to selecting _all_ columns, if we switched datasets. Otherwise, we keep the selected
    // params from the previous params
    let selectedColumnIDsOne = [];
    let selectedColumnIDsTwo = [];
    if (previousParams && previousParams.sheet_index_one == sheetIndexOne) {
        selectedColumnIDsOne = previousParams.selected_column_ids_one;
    }
    else {
        selectedColumnIDsOne = [...Object.keys(((_a = sheetDataArray[sheetIndexOne]) === null || _a === void 0 ? void 0 : _a.columnIDsMap) || {})];
    }
    if (previousParams && previousParams.sheet_index_two == sheetIndexTwo) {
        selectedColumnIDsTwo = previousParams.selected_column_ids_two;
    }
    else {
        selectedColumnIDsTwo = [...Object.keys(((_b = sheetDataArray[sheetIndexTwo]) === null || _b === void 0 ? void 0 : _b.columnIDsMap) || {})];
    }
    return {
        how: previousParams ? previousParams.how : 'lookup',
        sheet_index_one: sheetIndexOne,
        sheet_index_two: sheetIndexTwo,
        merge_key_column_ids: suggestedMergeKeys ? [suggestedMergeKeys] : [],
        selected_column_ids_one: selectedColumnIDsOne,
        selected_column_ids_two: selectedColumnIDsTwo,
    };
};
const MergeTaskpane = (props) => {
    const { params, setParams, error } = useLiveUpdatingParams(() => getDefaultMergeParams(props.sheetDataArray, props.selectedSheetIndex), StepType.Merge, props.mitoAPI, props.analysisData, 50 // 50 ms debounce delay
    );
    /*
        If the merge params are undefined, then display this error message.
    */
    if (params === undefined) {
        return React.createElement(DefaultEmptyTaskpane, { setUIState: props.setUIState, message: 'You need two dataframes before you can merge them.' });
    }
    const sheetDataOne = props.sheetDataArray[params.sheet_index_one];
    const sheetDataTwo = props.sheetDataArray[params.sheet_index_two];
    return (React.createElement(DefaultTaskpane, null,
        React.createElement(DefaultTaskpaneHeader, { header: "Merge Dataframes", setUIState: props.setUIState }),
        React.createElement(DefaultTaskpaneBody, null,
            React.createElement(Row, { justify: 'space-between', align: 'center', suppressTopBottomMargin: true },
                React.createElement(Col, { offsetRight: 1 },
                    React.createElement("p", { className: 'text-header-3' }, "Merge Type")),
                React.createElement(Col, { offsetRight: 2 },
                    React.createElement(Select, { value: params.how, onChange: (mergeType) => {
                            const newMergeTypeEnum = mergeType;
                            setParams(prevParams => {
                                return Object.assign(Object.assign({}, prevParams), { how: newMergeTypeEnum });
                            });
                        }, width: 'medium-large' },
                        React.createElement(DropdownItem, { title: MergeType.LOOKUP, subtext: "Includes all rows from the first sheet and only matching rows from the second sheet. If there are mulitple matches in the second sheet, only takes the first." }),
                        React.createElement(DropdownItem, { title: MergeType.LEFT, subtext: "Includes all rows from the first sheet and only matching rows from the second sheet. Includes all matches." }),
                        React.createElement(DropdownItem, { title: MergeType.RIGHT, subtext: "Includes all rows from the second sheet and only matching rows from the  first sheet. Includes all matches." }),
                        React.createElement(DropdownItem, { title: MergeType.INNER, subtext: "Only includes rows that have matches in both sheets." }),
                        React.createElement(DropdownItem, { title: MergeType.OUTER, subtext: "Includes all rows from both sheets, regardless of whether there is a match in the other sheet." }),
                        React.createElement(DropdownItem, { title: MergeType.UNIQUE_IN_LEFT, subtext: "Includes each row from the first sheet that doesn't have a match in the second sheet." }),
                        React.createElement(DropdownItem, { title: MergeType.UNIQUE_IN_RIGHT, subtext: "Includes each row from second sheet that doesn't have a match in the first sheet." })))),
            React.createElement(Spacer, { px: 20 }),
            React.createElement(MergeSheetSection, { params: params, setParams: setParams, sheetDataArray: props.sheetDataArray }),
            React.createElement(Spacer, { px: 20 }),
            React.createElement(MergeKeysSelectionSection, { params: params, setParams: setParams, sheetDataArray: props.sheetDataArray, error: error }),
            React.createElement(Spacer, { px: 20 }),
            React.createElement("p", { className: 'text-header-3' }, "Columns to Keep from First Dataframe"),
            params.how !== MergeType.UNIQUE_IN_RIGHT &&
                React.createElement(MultiToggleBox, { searchable: true, toggleAllIndexes: (indexesToToggle, newToggle) => {
                        const columnIDs = Object.keys((sheetDataOne === null || sheetDataOne === void 0 ? void 0 : sheetDataOne.columnDtypeMap) || {})
                            .map((columnID) => { return columnID; })
                            .filter((_, index) => {
                            return indexesToToggle.includes(index);
                        });
                        setParams(prevParams => {
                            const newSelectedColumnIDsOne = [...params.selected_column_ids_one];
                            if (newToggle) {
                                columnIDs.forEach((columnID) => {
                                    addIfAbsent(newSelectedColumnIDsOne, columnID);
                                });
                            }
                            else {
                                columnIDs.forEach((columnID) => {
                                    removeIfPresent(newSelectedColumnIDsOne, columnID);
                                });
                            }
                            return Object.assign(Object.assign({}, prevParams), { selected_column_ids_one: newSelectedColumnIDsOne });
                        });
                    }, height: 'medium' }, Object.entries((sheetDataOne === null || sheetDataOne === void 0 ? void 0 : sheetDataOne.columnDtypeMap) || {}).map(([columnID, columnDtype], index) => {
                    const columnHeader = sheetDataOne.columnIDsMap[columnID];
                    const toggled = params.selected_column_ids_one.includes(columnID); // TODO: make it true if merge key with OR
                    const isMergeKey = params.merge_key_column_ids.map(([mergeKeyOne,]) => { return mergeKeyOne; }).includes(columnID);
                    return (React.createElement(MultiToggleItem, { key: index, title: getDisplayColumnHeader(columnHeader), rightText: getDtypeValue(columnDtype), toggled: toggled || isMergeKey, disabled: isMergeKey, index: index, onToggle: () => {
                            setParams(prevParams => {
                                const newSelectedColumnIDsOne = [...params.selected_column_ids_one];
                                toggleInArray(newSelectedColumnIDsOne, columnID);
                                return Object.assign(Object.assign({}, prevParams), { selected_column_ids_one: newSelectedColumnIDsOne });
                            });
                        } }));
                })),
            params.how === MergeType.UNIQUE_IN_RIGHT &&
                React.createElement("p", null, "Finding the unique values in the second sheet doesn't keep any columns from the first sheet."),
            React.createElement(Spacer, { px: 20 }),
            React.createElement("div", null,
                React.createElement("p", { className: 'text-header-3' }, "Columns to Keep from Second Dataframe"),
                params.how !== MergeType.UNIQUE_IN_LEFT &&
                    React.createElement(MultiToggleBox, { searchable: true, toggleAllIndexes: (indexesToToggle, newToggle) => {
                            const columnIDs = Object.keys((sheetDataTwo === null || sheetDataTwo === void 0 ? void 0 : sheetDataTwo.columnDtypeMap) || {})
                                .map((columnID) => { return columnID; })
                                .filter((_, index) => {
                                return indexesToToggle.includes(index);
                            });
                            setParams(prevParams => {
                                const newSelectedColumnIDsTwo = [...params.selected_column_ids_two];
                                if (newToggle) {
                                    columnIDs.forEach((columnID) => {
                                        addIfAbsent(newSelectedColumnIDsTwo, columnID);
                                    });
                                }
                                else {
                                    columnIDs.forEach((columnID) => {
                                        removeIfPresent(newSelectedColumnIDsTwo, columnID);
                                    });
                                }
                                return Object.assign(Object.assign({}, prevParams), { selected_column_ids_two: newSelectedColumnIDsTwo });
                            });
                        }, height: 'medium' }, Object.entries((sheetDataTwo === null || sheetDataTwo === void 0 ? void 0 : sheetDataTwo.columnDtypeMap) || {}).map(([columnID, columnDtype], index) => {
                        const columnHeader = sheetDataTwo.columnIDsMap[columnID];
                        const toggled = params.selected_column_ids_two.includes(columnID);
                        const isMergeKey = params.merge_key_column_ids.map(([, mergeKeyTwo]) => { return mergeKeyTwo; }).includes(columnID);
                        return (React.createElement(MultiToggleItem, { key: index, title: getDisplayColumnHeader(columnHeader), rightText: getDtypeValue(columnDtype), toggled: toggled || isMergeKey, disabled: isMergeKey, index: index, onToggle: () => {
                                setParams(prevParams => {
                                    const newSelectedColumnIDsTwo = [...params.selected_column_ids_two];
                                    toggleInArray(newSelectedColumnIDsTwo, columnID);
                                    return Object.assign(Object.assign({}, prevParams), { selected_column_ids_two: newSelectedColumnIDsTwo });
                                });
                            } }));
                    })),
                params.how === MergeType.UNIQUE_IN_LEFT &&
                    React.createElement("p", null, "Finding the unique values in the first sheet doesn't keep any columns from the second sheet.")))));
};
export default MergeTaskpane;
//# sourceMappingURL=MergeTaskpane.js.map