// Copyright (c) Mito
import React from 'react';
import { ActionEnum } from '../../types';
import Dropdown from '../elements/Dropdown';
import DropdownSectionSeperator from '../elements/DropdownSectionSeperator';
import { makeToolbarDropdownItem } from './utils';
/**
 * Dropdown that displays all the actions that are available for general update
 * events, like undo and redo
 */
const ToolbarEditDropdown = (props) => {
    return (React.createElement(React.Fragment, null,
        React.createElement(Dropdown, { display: props.uiState.currOpenToolbarDropdown === 'Edit', closeDropdown: () => props.setUIState((prevUIState) => {
                if (prevUIState.currOpenToolbarDropdown === 'Edit') {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenToolbarDropdown: undefined });
                }
                return prevUIState;
            }), width: 'medium' },
            makeToolbarDropdownItem(props.actions[ActionEnum.Undo]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Redo]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Clear]),
            React.createElement(DropdownSectionSeperator, { isDropdownSectionSeperator: true }),
            makeToolbarDropdownItem(props.actions[ActionEnum.Copy]))));
};
export default ToolbarEditDropdown;
//# sourceMappingURL=ToolbarEditDropdown.js.map