import { useEffect, useRef } from "react";
/*
    This schedules an effect to run whenever there is a
    successful undo.
*/
export const useEffectOnUndo = (effect, analysisData) => {
    const numSteps = useRef(analysisData.stepSummaryList.length);
    useEffect(() => {
        const prevNumberSteps = numSteps.current;
        const newNumberSteps = analysisData.stepSummaryList.length;
        numSteps.current = newNumberSteps;
        if (newNumberSteps < prevNumberSteps) {
            effect();
        }
    }, [analysisData.stepSummaryList.length]);
};
//# sourceMappingURL=useEffectOnUndo.js.map