"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductStackHistory = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const core_1 = require("@aws-cdk/core");
const cloudformation_template_1 = require("./cloudformation-template");
const common_1 = require("./common");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * A Construct that contains a Service Catalog product stack with its previous deployments maintained.
 */
class ProductStackHistory extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_servicecatalog_ProductStackHistoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ProductStackHistory);
            }
            throw error;
        }
        props.productStack._setParentProductStackHistory(this);
        this.props = props;
    }
    /**
     * Retains product stack template as a snapshot when deployed and
     * retrieves a CloudFormationProductVersion for the current product version.
     */
    currentVersion() {
        return {
            cloudFormationTemplate: cloudformation_template_1.CloudFormationTemplate.fromProductStack(this.props.productStack),
            productVersionName: this.props.currentVersionName,
            description: this.props.description,
        };
    }
    /**
     * Retrieves a CloudFormationProductVersion from a previously deployed productVersionName.
     */
    versionFromSnapshot(productVersionName) {
        const productStackSnapshotDirectory = this.props.directory || common_1.DEFAULT_PRODUCT_STACK_SNAPSHOT_DIRECTORY;
        const templateFileKey = `${core_1.Names.uniqueId(this)}.${this.props.productStack.artifactId}.${productVersionName}.product.template.json`;
        const templateFilePath = path.join(productStackSnapshotDirectory, templateFileKey);
        if (!fs.existsSync(templateFilePath)) {
            throw new Error(`Template ${templateFileKey} cannot be found in ${productStackSnapshotDirectory}`);
        }
        return {
            cloudFormationTemplate: cloudformation_template_1.CloudFormationTemplate.fromAsset(templateFilePath),
            productVersionName: productVersionName,
            description: this.props.description,
        };
    }
    /**
     * Writes current template generated from Product Stack to a snapshot directory.
     *
     * @internal
     */
    _writeTemplateToSnapshot(cfn) {
        const productStackSnapshotDirectory = this.props.directory || common_1.DEFAULT_PRODUCT_STACK_SNAPSHOT_DIRECTORY;
        if (!fs.existsSync(productStackSnapshotDirectory)) {
            fs.mkdirSync(productStackSnapshotDirectory);
        }
        const templateFileKey = `${core_1.Names.uniqueId(this)}.${this.props.productStack.artifactId}.${this.props.currentVersionName}.product.template.json`;
        const templateFilePath = path.join(productStackSnapshotDirectory, templateFileKey);
        if (fs.existsSync(templateFilePath)) {
            const previousCfn = fs.readFileSync(templateFilePath).toString();
            if (previousCfn !== cfn && this.props.currentVersionLocked) {
                throw new Error(`Template has changed for ProductStack Version ${this.props.currentVersionName}.
        ${this.props.currentVersionName} already exist in ${productStackSnapshotDirectory}.
        Since locked has been set to ${this.props.currentVersionLocked},
        Either update the currentVersionName to deploy a new version or deploy the existing ProductStack snapshot.
        If ${this.props.currentVersionName} was unintentionally synthesized and not deployed, 
        delete the corresponding version from ${productStackSnapshotDirectory} and redeploy.`);
            }
        }
        fs.writeFileSync(templateFilePath, cfn);
    }
}
exports.ProductStackHistory = ProductStackHistory;
_a = JSII_RTTI_SYMBOL_1;
ProductStackHistory[_a] = { fqn: "@aws-cdk/aws-servicecatalog.ProductStackHistory", version: "1.186.0" };
//# sourceMappingURL=data:application/json;base64,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