/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.common;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.time.DateFormatter;
import org.openstreetmap.osmosis.core.time.DateParser;

public class ReplicationState {
    public static final String META_DATA_KEY = "replication.state";
    private Date timestamp;
    private long sequenceNumber;

    public ReplicationState() {
        this.timestamp = new Date(0L);
        this.sequenceNumber = 0L;
    }

    public ReplicationState(Date timestamp, long sequenceNumber) {
        this.timestamp = timestamp;
        this.sequenceNumber = sequenceNumber;
    }

    public ReplicationState(Map<String, String> properties) {
        this.load(properties);
    }

    private String loadProperty(Map<String, String> properties, String key) {
        if (!properties.containsKey(key)) {
            throw new OsmosisRuntimeException("The replication state doesn't contain a " + key + " property.");
        }
        return properties.get(key);
    }

    public void load(Map<String, String> properties) {
        this.timestamp = new DateParser().parse(this.loadProperty(properties, "timestamp"));
        this.sequenceNumber = Long.parseLong(this.loadProperty(properties, "sequenceNumber"));
    }

    public void store(Map<String, String> properties) {
        properties.put("timestamp", new DateFormatter().format(this.timestamp));
        properties.put("sequenceNumber", Long.toString(this.sequenceNumber));
    }

    public Map<String, String> store() {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.store(properties);
        return properties;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj instanceof ReplicationState) {
            ReplicationState compareState = (ReplicationState)obj;
            result = this.timestamp.equals(compareState.timestamp) && this.sequenceNumber == compareState.sequenceNumber;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return (int)this.sequenceNumber + (int)this.timestamp.getTime();
    }

    public String toString() {
        return "ReplicationState(timestamp=" + this.timestamp + ", sequenceNumber=" + this.sequenceNumber + ")";
    }
}

