# Example COMBINE/OMEX archives

This directory is a collection of example [COMBINE/OMEX archives](https://combinearchive.org/) that describe
simulations of biological models. As detailed below, the archives in this directory involve a variety of modeling frameworks
(e.g., logical, constraint-based), simulation algorithms (e.g., CVODE, SSA), and model formats (e.g., BNGL, SBML). All
of the simulations in the archives in this directory are described using the
[Simulation Experiment Description Markup Language (SED-ML)](https://sed-ml.org).

The purpose of this directory is two-fold:

* This directory serves as a reference for the community.
* The directory serves as a test suite for the [BioSimulators](https://biosimulators.org) registry of biosimulation tools.
  Tools submitted to the registry are validated using the software in this repository and the examples in this directory.

## Modeling frameworks employed by the example archives

The archives in this directory involve the following modeling frameworks:

| Name                          | SBO id                                                                                                           |
| ----------------------------- | ---------------------------------------------------------------------------------------------------------------- |
| flux balance                  | [SBO_0000624](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000624) |
| hybrid flux balance-continous | [SBO_0000684](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000684) |
| logical                       | [SBO_0000234](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000234) |
| non-spatial continuous        | [SBO_0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293) |
| non-spatial discrete          | [SBO_0000295](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000295) |
| resource balance              | [SBO_0000692](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000692) |
| spatial discrete              | [SBO_0000294](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000294) |

## Simulation algorithms employed by the example archives

The archives in this directory involve numerous simulation algorithms such as:

| Name                            | Acronym | KiSAO id                                                                                                                             |
| ------------------------------- | ------- | ------------------------------------------------------------------------------------------------------------------------------------ |
| Code Value Ordinary Differential Equation Solver | CVODE | [KISAO_0000019](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000019) |
| Stochastic Simulation Algorithm | SSA     | [KISAO_0000029](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000029) |

## Model formats employed by the example archives

The archives in this directory involve the following model formats:

| Name                                               | Acronym | EDAM id                                                                                                        |
| -------------------------------------------------- | ------- | -------------------------------------------------------------------------------------------------------------- |
| [BioNetGen Language](https://bionetgen.org)        | BNGL    | [format_3972](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_3972) |
| [CellML](https://cellml.org)        |     | [format_3240](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_3240) |
| [NeuroML](https://neuroml.org/)/[Low Entropy Model Specification Language](https://lems.github.io/LEMS/)        | LEMS    |   |
| [RBA TSV/XML format](https://sysbioinra.github.io/RBApy/usage.html)        |     |   |
| [Smoldyn Language](http://www.smoldyn.org/)        |     |   |
| [Systems Biology Markup Language](http://sbml.org) (core) | SBML    | [format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585) |
| [SBML flux balance constraints package](http://sbml.org/Documents/Specifications/SBML_Level_3/Packages/fbc) | SBML-fbc    | [format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585) |
| [SBML qualitative modeling package](http://sbml.org/Documents/Specifications/SBML_Level_3/Packages/qual) | SBML-qual    | [format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585) |
| [SBML MASS schema](https://masspy.readthedocs.io/en/stable/tutorials/reading_writing_models.html) |     |  |
| [XPP Language](http://www.math.pitt.edu/~bard/xpp/xpp.html) |     |  |


Note, more specific EDAM terms have SBML-fbc, SBML-qual, and other formats have been requested.

## Formats for the example data visualizations for the results of the example archives

The archives in this directory involve the following model formats:

| Name  | EDAM id |
| ----- | ------- |
| [SED-ML](https://http://sed-ml.org/) | [format_3685](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_3685) |
| [Vega](https://vega.github.io/vega/) | [format_3969](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_3969) |

## Compatibility of the example archives with simulation tools

Because each simulation tool only supports a limited number of modeling frameworks, simulation algorithms, and model formats, no simulation tool is capable of executing all of the archives in this directory. The [BioSimulators registry of biosimulation tools](https://biosimulators.org) contains detailed information about the modeling frameworks, simulation algorithms, and model formats supported by each registered tool. This information can be used to determine which tools are capable of executing a given archive.

Below is information about the compatibility of a selection of archives.

| Source | Archive  | Results | Data visualization (Vega) | Modeling framework (SBO id) | Simulation algorithm (KiSAO id) | Model format (EDAM id) | Compatibile simulators |
| ----- | -------- | ------- | --------------------------------- | --------------------------- | ------------------------------- | ---------------------- | ---------------------- |
| [Bordbar *Cell Syst*](https://doi.org/10.1016/j.cels.2015.10.003) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/mass/Bordbar-Cell-Syst-2015-RBC-metabolism.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/mass/Bordbar-Cell-Syst-2015-RBC-metabolism/reports.h5) | | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | CVODE ([0000019](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000019))           | SBML ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [tellurium](https://biosimulators.org/simulators/tellurium) |
| [Caravagna *J Theor Biol*](https://doi.org/10.1083/jcb.200306139) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Caravagna-J-Theor-Biol-2010-tumor-suppressive-oscillations.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Caravagna-J-Theor-Biol-2010-tumor-suppressive-oscillations/reports.h5) | | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | CVODE ([0000019](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000019))           | SBML ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [PySCeS](https://biosimulators.org/simulators/pysces), [tellurium](https://biosimulators.org/simulators/tellurium), [VCell](https://biosimulators.org/simulators/vcell)                 |
| [Chaouiya *BMC Syst Biol*](https://doi.org/10.1186/1752-0509-7-135) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-qual/Chaouiya-BMC-Syst-Biol-2013-EGF-TNFa-signaling.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-qual/Chaouiya-BMC-Syst-Biol-2013-EGF-TNFa-signaling/reports.h5) | | logical ([0000234](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000234)) | synchronous updating ([0000449](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000449))           | SBML qual ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [BoolNet](https://biosimulators.org/simulators/boolnet), [GINsim](https://biosimulators.org/simulators/ginsim) |
| [Ciliberto *J Cell Biol*](https://doi.org/10.1083/jcb.200306139) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Ciliberto-J-Cell-Biol-2003-morphogenesis-checkpoint-continuous.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Ciliberto-J-Cell-Biol-2003-morphogenesis-checkpoint-continuous/reports.h5) | [`.json`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Ciliberto-J-Cell-Biol-2003-morphogenesis-checkpoint-continuous/Figure3.vg.json) | non-spatial continuous ([0000295](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | CVODE ([0000019](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000019))           | SBML ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [PySCeS](https://biosimulators.org/simulators/pysces), [tellurium](https://biosimulators.org/simulators/tellurium), [VCell](https://biosimulators.org/simulators/vcell)                 |
| [Ciliberto *J Cell Biol*](https://doi.org/10.1083/jcb.200306139) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Ciliberto-J-Cell-Biol-2003-morphogenesis-checkpoint-Fehlberg.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Ciliberto-J-Cell-Biol-2003-morphogenesis-checkpoint-Fehlberg/reports.h5) |  | non-spatial continuous ([0000295](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | Fehlberg ([0000086](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000086))           | SBML ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [libSBMLSim](https://biosimulators.org/simulators/libsbmlsim), [tellurium](https://biosimulators.org/simulators/tellurium), [VCell](https://biosimulators.org/simulators/vcell) |
| [Dolan *PLoS Comput Biol*](https://doi.org/10.1371/journal.pcbi.1004246) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/bngl/Dolan-PLoS-Comput-Biol-2015-NHEJ.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/bngl/Dolan-PLoS-Comput-Biol-2015-NHEJ/reports.h5) | | non-spatial discrete ([0000295](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000295)) | NFsim ([0000263](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000263))           | BNGL ([format_3972](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_3972))     | [BioNetGen](https://biosimulators.org/simulators/bionetgen)  |
| [*E. coli*  core metabolism (COBRApy Team)](https://github.com/opencobra/cobrapy/blob/devel/src/cobra/test/data/textbook.xml.gz) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-fbc/Escherichia-coli-core-metabolism.omex)| [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-fbc/Escherichia-coli-core-metabolism/reports.h5) | [`.json`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-fbc/Escherichia-coli-core-metabolism/flux-map.vg.json) | flux balance ([0000624](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000624)) | FBA ([0000437](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000437))           | SBML fbc ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [COBRApy](https://biosimulators.org/simulators/cobrapy), [CBMPy](https://biosimulators.org/simulators/cbmpy)                 |
| [*E. coli*  resource allocation](https://doi.org/10.1016/j.ymben.2019.06.001) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/rba/Escherichia-coli-K12-WT.omex)| [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/rba/Escherichia-coli-K12-WT/reports.h5) | [`.json`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/rba/Escherichia-coli-K12-WT/flux-map.vg.json) | resource balance ([0000692](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000692)) | RBA ([0000669](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000669))           | RBA   | [RBApy](https://biosimulators.org/simulators/rbapy) |
| [Edelstein *Biol Cybern*](https://doi.org/10.1007/s004220050302) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Edelstein-Biol-Cybern-1996-Nicotinic-excitation.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Edelstein-Biol-Cybern-1996-Nicotinic-excitation/reports.h5) | [`.json`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Edelstein-Biol-Cybern-1996-Nicotinic-excitation/Figure_4b.vg.json) | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | LSODA ([0000088](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000088))           | SBML ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [GillesPy2](https://biosimulators.org/simulators/gillespy2), [PySCeS](https://biosimulators.org/simulators/pysces)                 |
| [Elowitz *Nature*](https://doi.org/10.1038/35002125) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Elowitz-Nature-2000-Repressilator.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Elowitz-Nature-2000-Repressilator/reports.h5) | [`.json`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Elowitz-Nature-2000-Repressilator/process-description-map.vg.json) | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | CVODE ([0000019](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000019))           | CellML ([format_3240](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_3240))     | [OpenCOR](https://biosimulators.org/simulators/opencor)                 |
| [Elowitz *Nature*](https://doi.org/10.1038/35002125) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/cellml/Elowitz-Nature-2000-Repressilator.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/cellml/Elowitz-Nature-2000-Repressilator/reports.h5) | [`.json`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/cellml/Elowitz-Nature-2000-Repressilator/process-description-map.vg.json) | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | CVODE ([0000019](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000019))           | SBML ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [PySCeS](https://biosimulators.org/simulators/pysces), [tellurium](https://biosimulators.org/simulators/tellurium), [VCell](https://biosimulators.org/simulators/vcell)                 |
| [Hodgkin-Huxley dynamics](https://github.com/NeuroML/pyNeuroML/blob/master/examples/LEMS_NML2_Ex5_DetCell.xml) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/neuroml-lems/Hodgkin-Huxley-cell-CVODE.omex)| [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/neuroml-lems/Hodgkin-Huxley-cell-CVODE/reports.h5) |  | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | CVODE ([0000019](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000019))           | NeuroML/LEMS    | [NEURON](https://biosimulators.org/simulators/neuron), [NetPyNe](https://biosimulators.org/simulators/netpyne) |
| [Hodgkin-Huxley dynamics](https://github.com/NeuroML/pyNeuroML/blob/master/examples/LEMS_NML2_Ex5_DetCell.xml) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/neuroml-lems/Hodgkin-Huxley-cell-Euler.omex)| [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/neuroml-lems/Hodgkin-Huxley-cell-Euler/reports.h5) |  | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | Euler forward method ([0000030](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000030))           | NeuroML/LEMS    | [pyNeuroML](https://biosimulators.org/simulators/pyneuroml)                 |
| [Irons *J Theor Biol*](https://doi.org/10.1016/j.jtbi.2008.12.028) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-qual/Irons-J-Theor-Biol-2009-yeast-cell-cycle.omex)| [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-qual/Irons-J-Theor-Biol-2009-yeast-cell-cycle/reports.h5) | [`.json`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-qual/Irons-J-Theor-Biol-2009-yeast-cell-cycle/activity-flow-diagram.vg.json) | logical ([0000234](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000234)) | synchronous updating ([0000449](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000449))           | SBML qual ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585)) | [BoolNet](https://biosimulators.org/simulators/boolnet), [GINsim](https://biosimulators.org/simulators/ginsim) |
| [Lorenz system](https://github.com/opencor/opencor/blob/master/models/tests/cellml/lorenz.cellml) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/cellml/Lorenz-system.omex)| [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/cellml/Lorenz-system/reports.h5) |  | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | CVODE ([0000019](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000019))           | OpenCOR    | [OpenCOR](https://biosimulators.org/simulators/opencor)                 |
| [Lotka-Volterra model (Smoldyn Team)](http://www.smoldyn.org/archive/examples/S8_reactions/lotvolt/lotvolt.txt) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/smoldyn/Lotka-Volterra.omex)| [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/smoldyn/Lotka-Volterra/reports.h5) |  | spatial discrete ([0000294](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000294)) | Smoluchowski method ([0000057](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000057))           | Smoldyn    | [Smoldyn](https://biosimulators.org/simulators/smoldyn)                 |
| [Parmar *BMC Syst Biol*](https://doi.org/10.1186/s12918-017-0431-3) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Parmar-BMC-Syst-Biol-2017-iron-distribution.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Parmar-BMC-Syst-Biol-2017-iron-distribution/reports.h5) | | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | CVODE ([0000019](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000019))           | SBML ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [PySCeS](https://biosimulators.org/simulators/pysces), [tellurium](https://biosimulators.org/simulators/tellurium), [VCell](https://biosimulators.org/simulators/vcell)                 |
| [Szymanska *J Theor Biol*](https://doi.org/10.1016/j.jtbi.2009.03.021) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Szymanska-J-Theor-Biol-2009-HSP-synthesis.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Szymanska-J-Theor-Biol-2009-HSP-synthesis/reports.h5) | | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | CVODES ([0000496](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000496))           | SBML ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [AMICI](https://biosimulators.org/simulators/amici)
| [Tomida *EMBO J*](https://doi.org/10.1093/emboj/cdg381) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Tomida-EMBO-J-2003-NFAT-translocation.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Tomida-EMBO-J-2003-NFAT-translocation/reports.h5) | [`.json`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Tomida-EMBO-J-2003-NFAT-translocation/Figure_3c.vg.json) | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | LSODA/LSODAR ([0000560](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000560))           | SBML ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [COPASI](https://biosimulators.org/simulators/copasi)                  |
| [Saglam toy gene regulatory network](https://github.com/biosimulators/Biosimulators_BioNetGen/blob/dev/tests/fixtures/test.bngl) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/bngl/test-bngl.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/bngl/test-bngl/reports.h5) | | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | CVODE ([0000019](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000019))           | BNGL ([format_3972](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_3972))     | [BioNetGen](https://biosimulators.org/simulators/bionetgen)  |
| [Varusai *Sci Rep*](https://doi.org/10.1038/s41598-017-18400-z) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Varusai-Sci-Rep-2018-mTOR-signaling-LSODA-LSODAR-SBML.omex) | [`.h5`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Varusai-Sci-Rep-2018-mTOR-signaling-LSODA-LSODAR-SBML/reports.h5) | | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | LSODA/LSODAR ([0000560](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000560))           | SBML ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [COPASI](https://biosimulators.org/simulators/copasi)                  |
| [Vilar *PNAS*](https://doi.org/10.1073/pnas.092133899) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/sbml-core/Vilar-PNAS-2002-minimal-circardian-clock.omex) | | | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)), non-spatial discrete ([0000295](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000295)) | CVODE ([0000019](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000019)) and NRM ([0000027](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000027))           | SBML ([format_2585](https://www.ebi.ac.uk/ols/ontologies/edam/terms?iri=http%3A%2F%2Fedamontology.org%2Fformat_2585))     | [VCell](https://biosimulators.org/simulators/vcell)                 |
| [Wu *Biochem Pharmacol*](https://doi.org/10.1016/j.bcp.2005.11.016) | [`.omex`](https://github.com/biosimulators/Biosimulators_test_suite/raw/dev/examples/xpp/Wu-Biochem-Pharmacol-2006-pituitary-GH3-cells.omex) | | | non-spatial continuous ([0000293](https://www.ebi.ac.uk/ols/ontologies/sbo/terms?iri=http%3A%2F%2Fbiomodels.net%2FSBO%2FSBO_0000293)) | CVODE ([0000019](https://www.ebi.ac.uk/ols/ontologies/kisao/terms?iri=http%3A%2F%2Fwww.biomodels.net%2Fkisao%2FKISAO%23KISAO_0000019))          | XPP      | [XPP](https://biosimulators.org/simulators/xpp)                 |
