"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainName = exports.SecurityPolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
const base_path_mapping_1 = require("./base-path-mapping");
const restapi_1 = require("./restapi");
/**
 * The minimum version of the SSL protocol that you want API Gateway to use for HTTPS connections.
 */
var SecurityPolicy;
(function (SecurityPolicy) {
    /** Cipher suite TLS 1.0 */
    SecurityPolicy["TLS_1_0"] = "TLS_1_0";
    /** Cipher suite TLS 1.2 */
    SecurityPolicy["TLS_1_2"] = "TLS_1_2";
})(SecurityPolicy = exports.SecurityPolicy || (exports.SecurityPolicy = {}));
class DomainName extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.basePaths = new Set();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_DomainNameProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DomainName);
            }
            throw error;
        }
        const endpointType = props.endpointType || restapi_1.EndpointType.REGIONAL;
        const edge = endpointType === restapi_1.EndpointType.EDGE;
        if (!core_1.Token.isUnresolved(props.domainName) && /[A-Z]/.test(props.domainName)) {
            throw new Error(`Domain name does not support uppercase letters. Got: ${props.domainName}`);
        }
        const mtlsConfig = this.configureMTLS(props.mtls);
        const resource = new apigateway_generated_1.CfnDomainName(this, 'Resource', {
            domainName: props.domainName,
            certificateArn: edge ? props.certificate.certificateArn : undefined,
            regionalCertificateArn: edge ? undefined : props.certificate.certificateArn,
            endpointConfiguration: { types: [endpointType] },
            mutualTlsAuthentication: mtlsConfig,
            securityPolicy: props.securityPolicy,
        });
        this.domainName = resource.ref;
        this.domainNameAliasDomainName = edge
            ? resource.attrDistributionDomainName
            : resource.attrRegionalDomainName;
        this.domainNameAliasHostedZoneId = edge
            ? resource.attrDistributionHostedZoneId
            : resource.attrRegionalHostedZoneId;
        if (props.mapping) {
            this.addBasePathMapping(props.mapping, {
                basePath: props.basePath,
            });
        }
    }
    /**
     * Imports an existing domain name.
     */
    static fromDomainNameAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_DomainNameAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromDomainNameAttributes);
            }
            throw error;
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.domainName = attrs.domainName;
                this.domainNameAliasDomainName = attrs.domainNameAliasTarget;
                this.domainNameAliasHostedZoneId = attrs.domainNameAliasHostedZoneId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Maps this domain to an API endpoint.
     * @param targetApi That target API endpoint, requests will be mapped to the deployment stage.
     * @param options Options for mapping to base path with or without a stage
     */
    addBasePathMapping(targetApi, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_IRestApi(targetApi);
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_BasePathMappingOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addBasePathMapping);
            }
            throw error;
        }
        if (this.basePaths.has(undefined)) {
            throw new Error('This domain name already has an empty base path. No additional base paths are allowed.');
        }
        this.basePaths.add(options.basePath);
        const basePath = options.basePath || '/';
        const id = `Map:${basePath}=>${core_1.Names.nodeUniqueId(targetApi.node)}`;
        return new base_path_mapping_1.BasePathMapping(this, id, {
            domainName: this,
            restApi: targetApi,
            ...options,
        });
    }
    configureMTLS(mtlsConfig) {
        if (!mtlsConfig)
            return undefined;
        return {
            truststoreUri: mtlsConfig.bucket.s3UrlForObject(mtlsConfig.key),
            truststoreVersion: mtlsConfig.version,
        };
    }
}
exports.DomainName = DomainName;
_a = JSII_RTTI_SYMBOL_1;
DomainName[_a] = { fqn: "@aws-cdk/aws-apigateway.DomainName", version: "1.190.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZG9tYWluLW5hbWUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJkb21haW4tbmFtZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFFQSx3Q0FBa0U7QUFFbEUsaUVBQXVEO0FBQ3ZELDJEQUE4RTtBQUM5RSx1Q0FBbUQ7QUFFbkQ7O0dBRUc7QUFDSCxJQUFZLGNBTVg7QUFORCxXQUFZLGNBQWM7SUFDeEIsMkJBQTJCO0lBQzNCLHFDQUFtQixDQUFBO0lBRW5CLDJCQUEyQjtJQUMzQixxQ0FBbUIsQ0FBQTtBQUNyQixDQUFDLEVBTlcsY0FBYyxHQUFkLHNCQUFjLEtBQWQsc0JBQWMsUUFNekI7QUFpRkQsTUFBYSxVQUFXLFNBQVEsZUFBUTtJQW9CdEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFzQjtRQUM5RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBSEYsY0FBUyxHQUFHLElBQUksR0FBRyxFQUFzQixDQUFDOzs7Ozs7K0NBbEJoRCxVQUFVOzs7O1FBdUJuQixNQUFNLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxJQUFJLHNCQUFZLENBQUMsUUFBUSxDQUFDO1FBQ2pFLE1BQU0sSUFBSSxHQUFHLFlBQVksS0FBSyxzQkFBWSxDQUFDLElBQUksQ0FBQztRQUVoRCxJQUFJLENBQUMsWUFBSyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLElBQUksT0FBTyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLEVBQUU7WUFDM0UsTUFBTSxJQUFJLEtBQUssQ0FBQyx3REFBd0QsS0FBSyxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUM7U0FDN0Y7UUFFRCxNQUFNLFVBQVUsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNsRCxNQUFNLFFBQVEsR0FBRyxJQUFJLG9DQUFhLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNuRCxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsY0FBYyxFQUFFLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFNBQVM7WUFDbkUsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsY0FBYztZQUMzRSxxQkFBcUIsRUFBRSxFQUFFLEtBQUssRUFBRSxDQUFDLFlBQVksQ0FBQyxFQUFFO1lBQ2hELHVCQUF1QixFQUFFLFVBQVU7WUFDbkMsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1NBQ3JDLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxVQUFVLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQztRQUUvQixJQUFJLENBQUMseUJBQXlCLEdBQUcsSUFBSTtZQUNuQyxDQUFDLENBQUMsUUFBUSxDQUFDLDBCQUEwQjtZQUNyQyxDQUFDLENBQUMsUUFBUSxDQUFDLHNCQUFzQixDQUFDO1FBRXBDLElBQUksQ0FBQywyQkFBMkIsR0FBRyxJQUFJO1lBQ3JDLENBQUMsQ0FBQyxRQUFRLENBQUMsNEJBQTRCO1lBQ3ZDLENBQUMsQ0FBQyxRQUFRLENBQUMsd0JBQXdCLENBQUM7UUFFdEMsSUFBSSxLQUFLLENBQUMsT0FBTyxFQUFFO1lBQ2pCLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFO2dCQUNyQyxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7YUFDekIsQ0FBQyxDQUFDO1NBQ0o7S0FDRjtJQXJERDs7T0FFRztJQUNJLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEyQjs7Ozs7Ozs7OztRQUM5RixNQUFNLE1BQU8sU0FBUSxlQUFRO1lBQTdCOztnQkFDa0IsZUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7Z0JBQzlCLDhCQUF5QixHQUFHLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQztnQkFDeEQsZ0NBQTJCLEdBQUcsS0FBSyxDQUFDLDJCQUEyQixDQUFDO1lBQ2xGLENBQUM7U0FBQTtRQUVELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0tBQzlCO0lBNENEOzs7O09BSUc7SUFDSSxrQkFBa0IsQ0FBQyxTQUFtQixFQUFFLFVBQWtDLEVBQUc7Ozs7Ozs7Ozs7O1FBQ2xGLElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsU0FBUyxDQUFDLEVBQUU7WUFDakMsTUFBTSxJQUFJLEtBQUssQ0FBQyx3RkFBd0YsQ0FBQyxDQUFDO1NBQzNHO1FBQ0QsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3JDLE1BQU0sUUFBUSxHQUFHLE9BQU8sQ0FBQyxRQUFRLElBQUksR0FBRyxDQUFDO1FBQ3pDLE1BQU0sRUFBRSxHQUFHLE9BQU8sUUFBUSxLQUFLLFlBQUssQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUM7UUFDcEUsT0FBTyxJQUFJLG1DQUFlLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRTtZQUNuQyxVQUFVLEVBQUUsSUFBSTtZQUNoQixPQUFPLEVBQUUsU0FBUztZQUNsQixHQUFHLE9BQU87U0FDWCxDQUFDLENBQUM7S0FDSjtJQUVPLGFBQWEsQ0FBQyxVQUF1QjtRQUMzQyxJQUFJLENBQUMsVUFBVTtZQUFFLE9BQU8sU0FBUyxDQUFDO1FBQ2xDLE9BQU87WUFDTCxhQUFhLEVBQUUsVUFBVSxDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztZQUMvRCxpQkFBaUIsRUFBRSxVQUFVLENBQUMsT0FBTztTQUN0QyxDQUFDO0tBQ0g7O0FBbEZILGdDQW1GQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGFjbSBmcm9tICdAYXdzLWNkay9hd3MtY2VydGlmaWNhdGVtYW5hZ2VyJztcbmltcG9ydCB7IElCdWNrZXQgfSBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0IHsgSVJlc291cmNlLCBOYW1lcywgUmVzb3VyY2UsIFRva2VuIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmbkRvbWFpbk5hbWUgfSBmcm9tICcuL2FwaWdhdGV3YXkuZ2VuZXJhdGVkJztcbmltcG9ydCB7IEJhc2VQYXRoTWFwcGluZywgQmFzZVBhdGhNYXBwaW5nT3B0aW9ucyB9IGZyb20gJy4vYmFzZS1wYXRoLW1hcHBpbmcnO1xuaW1wb3J0IHsgRW5kcG9pbnRUeXBlLCBJUmVzdEFwaSB9IGZyb20gJy4vcmVzdGFwaSc7XG5cbi8qKlxuICogVGhlIG1pbmltdW0gdmVyc2lvbiBvZiB0aGUgU1NMIHByb3RvY29sIHRoYXQgeW91IHdhbnQgQVBJIEdhdGV3YXkgdG8gdXNlIGZvciBIVFRQUyBjb25uZWN0aW9ucy5cbiAqL1xuZXhwb3J0IGVudW0gU2VjdXJpdHlQb2xpY3kge1xuICAvKiogQ2lwaGVyIHN1aXRlIFRMUyAxLjAgKi9cbiAgVExTXzFfMCA9ICdUTFNfMV8wJyxcblxuICAvKiogQ2lwaGVyIHN1aXRlIFRMUyAxLjIgKi9cbiAgVExTXzFfMiA9ICdUTFNfMV8yJyxcbn1cblxuZXhwb3J0IGludGVyZmFjZSBEb21haW5OYW1lT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgY3VzdG9tIGRvbWFpbiBuYW1lIGZvciB5b3VyIEFQSS4gVXBwZXJjYXNlIGxldHRlcnMgYXJlIG5vdCBzdXBwb3J0ZWQuXG4gICAqL1xuICByZWFkb25seSBkb21haW5OYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSByZWZlcmVuY2UgdG8gYW4gQVdTLW1hbmFnZWQgY2VydGlmaWNhdGUgZm9yIHVzZSBieSB0aGUgZWRnZS1vcHRpbWl6ZWRcbiAgICogZW5kcG9pbnQgZm9yIHRoZSBkb21haW4gbmFtZS4gRm9yIFwiRURHRVwiIGRvbWFpbiBuYW1lcywgdGhlIGNlcnRpZmljYXRlXG4gICAqIG5lZWRzIHRvIGJlIGluIHRoZSBVUyBFYXN0IChOLiBWaXJnaW5pYSkgcmVnaW9uLlxuICAgKi9cbiAgcmVhZG9ubHkgY2VydGlmaWNhdGU6IGFjbS5JQ2VydGlmaWNhdGU7XG5cbiAgLyoqXG4gICAqIFRoZSB0eXBlIG9mIGVuZHBvaW50IGZvciB0aGlzIERvbWFpbk5hbWUuXG4gICAqIEBkZWZhdWx0IFJFR0lPTkFMXG4gICAqL1xuICByZWFkb25seSBlbmRwb2ludFR5cGU/OiBFbmRwb2ludFR5cGU7XG5cbiAgLyoqXG4gICAqIFRoZSBUcmFuc3BvcnQgTGF5ZXIgU2VjdXJpdHkgKFRMUykgdmVyc2lvbiArIGNpcGhlciBzdWl0ZSBmb3IgdGhpcyBkb21haW4gbmFtZS5cbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtYXBpZ2F0ZXdheS1kb21haW5uYW1lLmh0bWxcbiAgICogQGRlZmF1bHQgU2VjdXJpdHlQb2xpY3kuVExTXzFfMFxuICAgKi9cbiAgcmVhZG9ubHkgc2VjdXJpdHlQb2xpY3k/OiBTZWN1cml0eVBvbGljeTtcblxuICAvKipcbiAgICogVGhlIG11dHVhbCBUTFMgYXV0aGVudGljYXRpb24gY29uZmlndXJhdGlvbiBmb3IgYSBjdXN0b20gZG9tYWluIG5hbWUuXG4gICAqIEBkZWZhdWx0IC0gbVRMUyBpcyBub3QgY29uZmlndXJlZC5cbiAgICovXG4gIHJlYWRvbmx5IG10bHM/OiBNVExTQ29uZmlnO1xuXG4gIC8qKlxuICAgKiBUaGUgYmFzZSBwYXRoIG5hbWUgdGhhdCBjYWxsZXJzIG9mIHRoZSBBUEkgbXVzdCBwcm92aWRlIGluIHRoZSBVUkwgYWZ0ZXJcbiAgICogdGhlIGRvbWFpbiBuYW1lIChlLmcuIGBleGFtcGxlLmNvbS9iYXNlLXBhdGhgKS4gSWYgeW91IHNwZWNpZnkgdGhpc1xuICAgKiBwcm9wZXJ0eSwgaXQgY2FuJ3QgYmUgYW4gZW1wdHkgc3RyaW5nLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG1hcCByZXF1ZXN0cyBmcm9tIHRoZSBkb21haW4gcm9vdCAoZS5nLiBgZXhhbXBsZS5jb21gKS4gSWYgdGhpc1xuICAgKiBpcyB1bmRlZmluZWQsIG5vIGFkZGl0aW9uYWwgbWFwcGluZ3Mgd2lsbCBiZSBhbGxvd2VkIG9uIHRoaXMgZG9tYWluIG5hbWUuXG4gICAqL1xuICByZWFkb25seSBiYXNlUGF0aD86IHN0cmluZztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBEb21haW5OYW1lUHJvcHMgZXh0ZW5kcyBEb21haW5OYW1lT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBJZiBzcGVjaWZpZWQsIGFsbCByZXF1ZXN0cyB0byB0aGlzIGRvbWFpbiB3aWxsIGJlIG1hcHBlZCB0byB0aGUgcHJvZHVjdGlvblxuICAgKiBkZXBsb3ltZW50IG9mIHRoaXMgQVBJLiBJZiB5b3Ugd2lzaCB0byBtYXAgdGhpcyBkb21haW4gdG8gbXVsdGlwbGUgQVBJc1xuICAgKiB3aXRoIGRpZmZlcmVudCBiYXNlIHBhdGhzLCBkb24ndCBzcGVjaWZ5IHRoaXMgb3B0aW9uIGFuZCB1c2VcbiAgICogYGFkZEJhc2VQYXRoTWFwcGluZ2AuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0geW91IHdpbGwgaGF2ZSB0byBjYWxsIGBhZGRCYXNlUGF0aE1hcHBpbmdgIHRvIG1hcCB0aGlzIGRvbWFpbiB0b1xuICAgKiBBUEkgZW5kcG9pbnRzLlxuICAgKi9cbiAgcmVhZG9ubHkgbWFwcGluZz86IElSZXN0QXBpO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIElEb21haW5OYW1lIGV4dGVuZHMgSVJlc291cmNlIHtcbiAgLyoqXG4gICAqIFRoZSBkb21haW4gbmFtZSAoZS5nLiBgZXhhbXBsZS5jb21gKVxuICAgKlxuICAgKiBAYXR0cmlidXRlIERvbWFpbk5hbWVcbiAgICovXG4gIHJlYWRvbmx5IGRvbWFpbk5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIFJvdXRlNTMgYWxpYXMgdGFyZ2V0IHRvIHVzZSBpbiBvcmRlciB0byBjb25uZWN0IGEgcmVjb3JkIHNldCB0byB0aGlzIGRvbWFpbiB0aHJvdWdoIGFuIGFsaWFzLlxuICAgKlxuICAgKiBAYXR0cmlidXRlIERpc3RyaWJ1dGlvbkRvbWFpbk5hbWUsUmVnaW9uYWxEb21haW5OYW1lXG4gICAqL1xuICByZWFkb25seSBkb21haW5OYW1lQWxpYXNEb21haW5OYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBSb3V0ZTUzIGhvc3RlZCB6b25lIElEIHRvIHVzZSBpbiBvcmRlciB0byBjb25uZWN0IGEgcmVjb3JkIHNldCB0byB0aGlzIGRvbWFpbiB0aHJvdWdoIGFuIGFsaWFzLlxuICAgKlxuICAgKiBAYXR0cmlidXRlIERpc3RyaWJ1dGlvbkhvc3RlZFpvbmVJZCxSZWdpb25hbEhvc3RlZFpvbmVJZFxuICAgKi9cbiAgcmVhZG9ubHkgZG9tYWluTmFtZUFsaWFzSG9zdGVkWm9uZUlkOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBEb21haW5OYW1lIGV4dGVuZHMgUmVzb3VyY2UgaW1wbGVtZW50cyBJRG9tYWluTmFtZSB7XG5cbiAgLyoqXG4gICAqIEltcG9ydHMgYW4gZXhpc3RpbmcgZG9tYWluIG5hbWUuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21Eb21haW5OYW1lQXR0cmlidXRlcyhzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBhdHRyczogRG9tYWluTmFtZUF0dHJpYnV0ZXMpOiBJRG9tYWluTmFtZSB7XG4gICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgUmVzb3VyY2UgaW1wbGVtZW50cyBJRG9tYWluTmFtZSB7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgZG9tYWluTmFtZSA9IGF0dHJzLmRvbWFpbk5hbWU7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgZG9tYWluTmFtZUFsaWFzRG9tYWluTmFtZSA9IGF0dHJzLmRvbWFpbk5hbWVBbGlhc1RhcmdldDtcbiAgICAgIHB1YmxpYyByZWFkb25seSBkb21haW5OYW1lQWxpYXNIb3N0ZWRab25lSWQgPSBhdHRycy5kb21haW5OYW1lQWxpYXNIb3N0ZWRab25lSWQ7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gIHB1YmxpYyByZWFkb25seSBkb21haW5OYW1lOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBkb21haW5OYW1lQWxpYXNEb21haW5OYW1lOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBkb21haW5OYW1lQWxpYXNIb3N0ZWRab25lSWQ6IHN0cmluZztcbiAgcHJpdmF0ZSByZWFkb25seSBiYXNlUGF0aHMgPSBuZXcgU2V0PHN0cmluZyB8IHVuZGVmaW5lZD4oKTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRG9tYWluTmFtZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IGVuZHBvaW50VHlwZSA9IHByb3BzLmVuZHBvaW50VHlwZSB8fCBFbmRwb2ludFR5cGUuUkVHSU9OQUw7XG4gICAgY29uc3QgZWRnZSA9IGVuZHBvaW50VHlwZSA9PT0gRW5kcG9pbnRUeXBlLkVER0U7XG5cbiAgICBpZiAoIVRva2VuLmlzVW5yZXNvbHZlZChwcm9wcy5kb21haW5OYW1lKSAmJiAvW0EtWl0vLnRlc3QocHJvcHMuZG9tYWluTmFtZSkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgRG9tYWluIG5hbWUgZG9lcyBub3Qgc3VwcG9ydCB1cHBlcmNhc2UgbGV0dGVycy4gR290OiAke3Byb3BzLmRvbWFpbk5hbWV9YCk7XG4gICAgfVxuXG4gICAgY29uc3QgbXRsc0NvbmZpZyA9IHRoaXMuY29uZmlndXJlTVRMUyhwcm9wcy5tdGxzKTtcbiAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBDZm5Eb21haW5OYW1lKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIGRvbWFpbk5hbWU6IHByb3BzLmRvbWFpbk5hbWUsXG4gICAgICBjZXJ0aWZpY2F0ZUFybjogZWRnZSA/IHByb3BzLmNlcnRpZmljYXRlLmNlcnRpZmljYXRlQXJuIDogdW5kZWZpbmVkLFxuICAgICAgcmVnaW9uYWxDZXJ0aWZpY2F0ZUFybjogZWRnZSA/IHVuZGVmaW5lZCA6IHByb3BzLmNlcnRpZmljYXRlLmNlcnRpZmljYXRlQXJuLFxuICAgICAgZW5kcG9pbnRDb25maWd1cmF0aW9uOiB7IHR5cGVzOiBbZW5kcG9pbnRUeXBlXSB9LFxuICAgICAgbXV0dWFsVGxzQXV0aGVudGljYXRpb246IG10bHNDb25maWcsXG4gICAgICBzZWN1cml0eVBvbGljeTogcHJvcHMuc2VjdXJpdHlQb2xpY3ksXG4gICAgfSk7XG5cbiAgICB0aGlzLmRvbWFpbk5hbWUgPSByZXNvdXJjZS5yZWY7XG5cbiAgICB0aGlzLmRvbWFpbk5hbWVBbGlhc0RvbWFpbk5hbWUgPSBlZGdlXG4gICAgICA/IHJlc291cmNlLmF0dHJEaXN0cmlidXRpb25Eb21haW5OYW1lXG4gICAgICA6IHJlc291cmNlLmF0dHJSZWdpb25hbERvbWFpbk5hbWU7XG5cbiAgICB0aGlzLmRvbWFpbk5hbWVBbGlhc0hvc3RlZFpvbmVJZCA9IGVkZ2VcbiAgICAgID8gcmVzb3VyY2UuYXR0ckRpc3RyaWJ1dGlvbkhvc3RlZFpvbmVJZFxuICAgICAgOiByZXNvdXJjZS5hdHRyUmVnaW9uYWxIb3N0ZWRab25lSWQ7XG5cbiAgICBpZiAocHJvcHMubWFwcGluZykge1xuICAgICAgdGhpcy5hZGRCYXNlUGF0aE1hcHBpbmcocHJvcHMubWFwcGluZywge1xuICAgICAgICBiYXNlUGF0aDogcHJvcHMuYmFzZVBhdGgsXG4gICAgICB9KTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogTWFwcyB0aGlzIGRvbWFpbiB0byBhbiBBUEkgZW5kcG9pbnQuXG4gICAqIEBwYXJhbSB0YXJnZXRBcGkgVGhhdCB0YXJnZXQgQVBJIGVuZHBvaW50LCByZXF1ZXN0cyB3aWxsIGJlIG1hcHBlZCB0byB0aGUgZGVwbG95bWVudCBzdGFnZS5cbiAgICogQHBhcmFtIG9wdGlvbnMgT3B0aW9ucyBmb3IgbWFwcGluZyB0byBiYXNlIHBhdGggd2l0aCBvciB3aXRob3V0IGEgc3RhZ2VcbiAgICovXG4gIHB1YmxpYyBhZGRCYXNlUGF0aE1hcHBpbmcodGFyZ2V0QXBpOiBJUmVzdEFwaSwgb3B0aW9uczogQmFzZVBhdGhNYXBwaW5nT3B0aW9ucyA9IHsgfSkge1xuICAgIGlmICh0aGlzLmJhc2VQYXRocy5oYXModW5kZWZpbmVkKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdUaGlzIGRvbWFpbiBuYW1lIGFscmVhZHkgaGFzIGFuIGVtcHR5IGJhc2UgcGF0aC4gTm8gYWRkaXRpb25hbCBiYXNlIHBhdGhzIGFyZSBhbGxvd2VkLicpO1xuICAgIH1cbiAgICB0aGlzLmJhc2VQYXRocy5hZGQob3B0aW9ucy5iYXNlUGF0aCk7XG4gICAgY29uc3QgYmFzZVBhdGggPSBvcHRpb25zLmJhc2VQYXRoIHx8ICcvJztcbiAgICBjb25zdCBpZCA9IGBNYXA6JHtiYXNlUGF0aH09PiR7TmFtZXMubm9kZVVuaXF1ZUlkKHRhcmdldEFwaS5ub2RlKX1gO1xuICAgIHJldHVybiBuZXcgQmFzZVBhdGhNYXBwaW5nKHRoaXMsIGlkLCB7XG4gICAgICBkb21haW5OYW1lOiB0aGlzLFxuICAgICAgcmVzdEFwaTogdGFyZ2V0QXBpLFxuICAgICAgLi4ub3B0aW9ucyxcbiAgICB9KTtcbiAgfVxuXG4gIHByaXZhdGUgY29uZmlndXJlTVRMUyhtdGxzQ29uZmlnPzogTVRMU0NvbmZpZyk6IENmbkRvbWFpbk5hbWUuTXV0dWFsVGxzQXV0aGVudGljYXRpb25Qcm9wZXJ0eSB8IHVuZGVmaW5lZCB7XG4gICAgaWYgKCFtdGxzQ29uZmlnKSByZXR1cm4gdW5kZWZpbmVkO1xuICAgIHJldHVybiB7XG4gICAgICB0cnVzdHN0b3JlVXJpOiBtdGxzQ29uZmlnLmJ1Y2tldC5zM1VybEZvck9iamVjdChtdGxzQ29uZmlnLmtleSksXG4gICAgICB0cnVzdHN0b3JlVmVyc2lvbjogbXRsc0NvbmZpZy52ZXJzaW9uLFxuICAgIH07XG4gIH1cbn1cblxuZXhwb3J0IGludGVyZmFjZSBEb21haW5OYW1lQXR0cmlidXRlcyB7XG4gIC8qKlxuICAgKiBUaGUgZG9tYWluIG5hbWUgKGUuZy4gYGV4YW1wbGUuY29tYClcbiAgICovXG4gIHJlYWRvbmx5IGRvbWFpbk5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIFJvdXRlNTMgYWxpYXMgdGFyZ2V0IHRvIHVzZSBpbiBvcmRlciB0byBjb25uZWN0IGEgcmVjb3JkIHNldCB0byB0aGlzIGRvbWFpbiB0aHJvdWdoIGFuIGFsaWFzLlxuICAgKi9cbiAgcmVhZG9ubHkgZG9tYWluTmFtZUFsaWFzVGFyZ2V0OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBSb3V0ZTUzIGhvc3RlZCB6b25lIElEIHRvIHVzZSBpbiBvcmRlciB0byBjb25uZWN0IGEgcmVjb3JkIHNldCB0byB0aGlzIGRvbWFpbiB0aHJvdWdoIGFuIGFsaWFzLlxuICAgKi9cbiAgcmVhZG9ubHkgZG9tYWluTmFtZUFsaWFzSG9zdGVkWm9uZUlkOiBzdHJpbmc7XG59XG5cbi8qKlxuICogVGhlIG1UTFMgYXV0aGVudGljYXRpb24gY29uZmlndXJhdGlvbiBmb3IgYSBjdXN0b20gZG9tYWluIG5hbWUuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgTVRMU0NvbmZpZyB7XG4gIC8qKlxuICAgKiBUaGUgYnVja2V0IHRoYXQgdGhlIHRydXN0IHN0b3JlIGlzIGhvc3RlZCBpbi5cbiAgICovXG4gIHJlYWRvbmx5IGJ1Y2tldDogSUJ1Y2tldDtcblxuICAvKipcbiAgICogVGhlIGtleSBpbiBTMyB0byBsb29rIGF0IGZvciB0aGUgdHJ1c3Qgc3RvcmUuXG4gICAqL1xuICByZWFkb25seSBrZXk6IHN0cmluZztcblxuICAvKipcbiAgICogIFRoZSB2ZXJzaW9uIG9mIHRoZSBTMyBvYmplY3QgdGhhdCBjb250YWlucyB5b3VyIHRydXN0c3RvcmUuXG4gICAqICBUbyBzcGVjaWZ5IGEgdmVyc2lvbiwgeW91IG11c3QgaGF2ZSB2ZXJzaW9uaW5nIGVuYWJsZWQgZm9yIHRoZSBTMyBidWNrZXQuXG4gICAqICBAZGVmYXVsdCAtIGxhdGVzdCB2ZXJzaW9uXG4gICAqL1xuICByZWFkb25seSB2ZXJzaW9uPzogc3RyaW5nO1xufVxuIl19