"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaybackKeyPair = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("aws-cdk-lib");
const aws_ivs_1 = require("aws-cdk-lib/aws-ivs");
/**
 * Reference to a new or existing IVS Playback Key Pair
 */
class PlaybackKeyPairBase extends core.Resource {
}
/**
  A new IVS Playback Key Pair
*/
class PlaybackKeyPair extends PlaybackKeyPairBase {
    constructor(scope, id, props) {
        super(scope, id, {});
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ivs_alpha_PlaybackKeyPairProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.name && !core.Token.isUnresolved(props.name) && !/^[a-zA-Z0-9-_]*$/.test(props.name)) {
            throw new Error(`name must contain only numbers, letters, hyphens and underscores, got: '${props.name}'`);
        }
        const resource = new aws_ivs_1.CfnPlaybackKeyPair(this, 'Resource', {
            publicKeyMaterial: props.publicKeyMaterial,
            name: props.name,
        });
        this.playbackKeyPairArn = resource.attrArn;
        this.playbackKeyPairFingerprint = resource.attrFingerprint;
    }
}
exports.PlaybackKeyPair = PlaybackKeyPair;
_a = JSII_RTTI_SYMBOL_1;
PlaybackKeyPair[_a] = { fqn: "@aws-cdk/aws-ivs-alpha.PlaybackKeyPair", version: "2.23.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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