"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const index_1 = require("./index");
const cdk = require("@aws-cdk/core");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const path = require("path");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'testing-stack', { env });
        const vpc = new aws_ec2_1.Vpc(stack, 'Vpc', { maxAzs: 3, natGateways: 1 });
        // the DatabaseCluster sharing the same vpc with the ServerlessLaravel
        const db = new index_1.DatabaseCluster(stack, 'DatabaseCluster', {
            vpc,
            instanceType: new aws_ec2_1.InstanceType('t3.small'),
            rdsProxy: true,
            instanceCapacity: 1,
        });
        // the ServerlessLaravel
        new index_1.ServerlessLaravel(stack, 'ServerlessLaravel', {
            brefLayerVersion: 'arn:aws:lambda:ap-northeast-1:209497400698:layer:php-74-fpm:11',
            laravelPath: path.join(__dirname, '../codebase'),
            vpc,
            databaseConfig: {
                writerEndpoint: db.rdsProxy.endpoint,
            },
        });
        new cdk.CfnOutput(stack, 'RDSProxyEndpoint', { value: db.rdsProxy.endpoint });
        new cdk.CfnOutput(stack, 'DBMasterUser', { value: db.masterUser });
        new cdk.CfnOutput(stack, 'DBMasterPasswordSecret', { value: db.masterPassword.secretArn });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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