"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddHeader = void 0;
/**
 * Adds a header to the received email
 */
class AddHeader {
    constructor(props) {
        if (!/^[a-zA-Z0-9-]{1,50}$/.test(props.name)) {
            // eslint-disable-next-line max-len
            throw new Error('Header `name` must be between 1 and 50 characters, inclusive, and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.');
        }
        if (!/^[^\n\r]{0,2047}$/.test(props.value)) {
            throw new Error('Header `value` must be less than 2048 characters, and must not contain newline characters ("\r" or "\n").');
        }
        this.name = props.name;
        this.value = props.value;
    }
    bind(_rule) {
        return {
            addHeaderAction: {
                headerName: this.name,
                headerValue: this.value,
            },
        };
    }
}
exports.AddHeader = AddHeader;
//# sourceMappingURL=data:application/json;base64,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