"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stop = void 0;
/**
 * Terminates the evaluation of the receipt rule set and optionally publishes a
 * notification to Amazon SNS.
 */
class Stop {
    constructor(props = {}) {
        this.props = props;
    }
    bind(_rule) {
        return {
            stopAction: {
                scope: 'RuleSet',
                topicArn: this.props.topic ? this.props.topic.topicArn : undefined,
            },
        };
    }
}
exports.Stop = Stop;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RvcC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInN0b3AudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBYUE7OztHQUdHO0FBQ0gsTUFBYSxJQUFJO0lBQ2YsWUFBNkIsUUFBbUIsRUFBRTtRQUFyQixVQUFLLEdBQUwsS0FBSyxDQUFnQjtJQUNsRCxDQUFDO0lBRU0sSUFBSSxDQUFDLEtBQXVCO1FBQ2pDLE9BQU87WUFDTCxVQUFVLEVBQUU7Z0JBQ1YsS0FBSyxFQUFFLFNBQVM7Z0JBQ2hCLFFBQVEsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxTQUFTO2FBQ25FO1NBQ0YsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQVpELG9CQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgc2VzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zZXMnO1xuaW1wb3J0ICogYXMgc25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnO1xuXG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciBhIHN0b3AgYWN0aW9uLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFN0b3BQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgU05TIHRvcGljIHRvIG5vdGlmeSB3aGVuIHRoZSBzdG9wIGFjdGlvbiBpcyB0YWtlbi5cbiAgICovXG4gIHJlYWRvbmx5IHRvcGljPzogc25zLklUb3BpYztcbn1cblxuLyoqXG4gKiBUZXJtaW5hdGVzIHRoZSBldmFsdWF0aW9uIG9mIHRoZSByZWNlaXB0IHJ1bGUgc2V0IGFuZCBvcHRpb25hbGx5IHB1Ymxpc2hlcyBhXG4gKiBub3RpZmljYXRpb24gdG8gQW1hem9uIFNOUy5cbiAqL1xuZXhwb3J0IGNsYXNzIFN0b3AgaW1wbGVtZW50cyBzZXMuSVJlY2VpcHRSdWxlQWN0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwcm9wczogU3RvcFByb3BzID0ge30pIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF9ydWxlOiBzZXMuSVJlY2VpcHRSdWxlKTogc2VzLlJlY2VpcHRSdWxlQWN0aW9uQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgc3RvcEFjdGlvbjoge1xuICAgICAgICBzY29wZTogJ1J1bGVTZXQnLFxuICAgICAgICB0b3BpY0FybjogdGhpcy5wcm9wcy50b3BpYyA/IHRoaXMucHJvcHMudG9waWMudG9waWNBcm4gOiB1bmRlZmluZWQsXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cbiJdfQ==