import numpy as np
from microconventions import sign_changes, is_process


# --------------------------------------------------------------------------
#            Monte Carlo
# --------------------------------------------------------------------------

def inv_cdf_walk(inv_cdf, k: int, x0: float) -> float:
    """ Generate sample from sum of independent increments generated by inverse cdf function
         inv_cdf  func   taking (0,1) --> R
         k        int    Number of steps
         x0       float  Starting value
    """
    # See crawler_examples/decastyle_cat for usage example
    x = x0
    for _ in range(k):
        u = np.random.rand()
        dx = inv_cdf(u)
        x = x + dx
    return x
