// Copyright (c) Mito
import React from 'react';
import DropdownButton from '../../elements/DropdownButton';
import Row from '../../spacing/Row';
import Col from '../../spacing/Col';
import '../../../../css/taskpanes/Graph/AxisSection.css';
import DropdownItem from '../../elements/DropdownItem';
import { columnIDMapToDisplayHeadersMap, getDisplayColumnHeader } from '../../../utils/columnHeaders';
import SelectAndXIconCard from '../../elements/SelectAndXIconCard';
export var GraphAxisType;
(function (GraphAxisType) {
    GraphAxisType["X_AXIS"] = "X axis";
    GraphAxisType["Y_AXIS"] = "Y axis";
})(GraphAxisType || (GraphAxisType = {}));
/*
    The Axis Section contains all of the fields needed to manipulate the selected
    column headers for each axis of the graph.
*/
const AxisSection = (props) => {
    // Filter the column headers that the user can select to only the columns that are the correct type for the graph
    const selectableColumnIDs = Object.keys(props.columnIDsMap || {});
    // Create Large Selects and delete buttons for each of the columns that have already been selected
    const selectedColumnHeaderSelects = props.selectedColumnIDs.map((columnID, i) => {
        return ((React.createElement(SelectAndXIconCard, { key: i, value: columnID, titleMap: columnIDMapToDisplayHeadersMap(props.columnIDsMap), onChange: (columnID) => {
                props.updateAxisData(props.graphAxis, i, columnID);
            }, onDelete: () => props.updateAxisData(props.graphAxis, i), selectableValues: selectableColumnIDs })));
    });
    // Calculate if the axis should be disabled for any of the following three reasons. 
    const numSelectedColumns = props.selectedColumnIDs.length;
    const numOtherAxisSelectedColumns = props.otherAxisSelectedColumnIDs.length;
    /* 3. If there are already four series being graphed, then don't let the user add another series */
    const disabledDueToMaxSeriesReachedBool = numSelectedColumns + numOtherAxisSelectedColumns >= 10;
    return (React.createElement("div", null,
        React.createElement(Row, { justify: 'space-between', align: 'center', title: `Select columns to graph on the ${props.graphAxis}.` },
            React.createElement(Col, null,
                React.createElement("div", { className: 'text-header-3' }, props.graphAxis)),
            React.createElement(Col, null,
                React.createElement(DropdownButton, { text: '+ Add', width: 'small', disabled: disabledDueToMaxSeriesReachedBool, searchable: true }, selectableColumnIDs.map(columnID => {
                    const columnHeader = props.columnIDsMap[columnID];
                    return (React.createElement(DropdownItem, { key: columnID, title: getDisplayColumnHeader(columnHeader), onClick: () => {
                            props.updateAxisData(props.graphAxis, props.selectedColumnIDs.length, columnID);
                        } }));
                })))),
        disabledDueToMaxSeriesReachedBool &&
            React.createElement("div", { className: 'text-subtext-1 text-align-left' }, "You can only graph ten series at once."),
        selectedColumnHeaderSelects));
};
export default AxisSection;
//# sourceMappingURL=AxisSection.js.map