// Copyright (c) Mito
import React from 'react';
import { classNames } from '../../utils/classNames';
import { getToolbarItemIcon } from './utils';
/**
 * The ToolbarButton component is used to create each
 * button in the Toolbar.
 */
const ToolbarButton = (props) => {
    const highlightToobarItemClass = props.highlightToolbarButton === true ? 'toolbar-button-draw-attention' : '';
    const icons = getToolbarItemIcon(props.toolbarButtonType);
    return (React.createElement("div", { className: 'toolbar-button-container', id: props.id, onClick: props.onClick },
        React.createElement("button", { className: classNames('toolbar-button', 'vertical-align-content', highlightToobarItemClass), type: "button" },
            React.createElement("span", { title: props.buttonSubtext },
                React.createElement("div", { className: 'toolbar-button-icon-container' },
                    React.createElement("div", { className: 'toolbar-button-icon-dark' }, icons.darkIcon),
                    React.createElement("div", { className: 'toolbar-button-icon-light' }, icons.lightIcon)),
                React.createElement("p", { className: 'toolbar-button-label' }, props.buttonTitle))),
        props.displayChildren && props.children !== undefined && props.children));
};
export default ToolbarButton;
//# sourceMappingURL=ToolbarButton.js.map